/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.ParentEntity;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseFolderDto;
import org.squashtest.tm.plugin.rest.repository.RestTestCaseFolderRepository;
import org.squashtest.tm.plugin.rest.service.RestTestCaseFolderService;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.plugin.rest.utils.PaginationUtils;
import org.squashtest.tm.service.library.FolderModificationService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;

@Service
@Transactional
public class RestTestCaseFolderServiceImpl
implements RestTestCaseFolderService {
    @Inject
    @Qualifier(value="squashtest.tm.service.TestCaseFolderModificationService")
    private FolderModificationService<TestCaseFolder> nativeService;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private RestTestCaseFolderRepository dao;
    @Inject
    private TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    @Inject
    private CustomFieldValueHelper customFieldValueHelper;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    @Transactional(readOnly=true)
    public TestCaseFolder getOne(Long id) {
        return (TestCaseFolder)this.nativeService.findFolder(id.longValue());
    }

    @Override
    @Transactional(readOnly=true)
    public Page<TestCaseFolder> findAllReadable(Pageable pageable) {
        List projectIds = this.projectFinder.findReadableProjectIdsOnTestCaseLibrary();
        return projectIds.isEmpty() ? PaginationUtils.emptyPage(pageable) : this.dao.findAllInProjects(projectIds, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TestCaseFolder> findAllByProjectIds(List<Long> projectIds) {
        return this.dao.findAllByProjects(projectIds);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#folderId,'org.squashtest.tm.domain.testcase.TestCaseFolder' , 'READ')")
    public Page<TestCaseLibraryNode> findFolderContent(long folderId, Pageable pageable) {
        return this.dao.findFolderContent(folderId, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#folderId,'org.squashtest.tm.domain.testcase.TestCaseFolder' , 'READ')")
    public Page<TestCaseLibraryNode> findFolderAllContent(long folderId, Pageable pageable) {
        return this.dao.findFolderAllContent(folderId, pageable);
    }

    @Override
    public TestCaseFolder addTestCaseFolder(TestCaseFolderDto folderDto) {
        TestCaseFolder folder = new TestCaseFolder();
        folder.setName(folderDto.getName());
        folder.setDescription(folderDto.getDescription());
        this.addToParent(folderDto, folder);
        if (folderDto.getCustomFields() != null) {
            List<CustomFieldValueDto> listCufsDto = folderDto.getCustomFields();
            this.customFieldValueHelper.patchCustomFieldValue((BoundEntity)folder, listCufsDto);
        }
        this.entityManager.persist((Object)folder);
        this.entityManager.flush();
        return folder;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.testcase.TestCaseFolder' , 'WRITE')")
    public TestCaseFolder patchTestCaseFolder(TestCaseFolderDto folderPatch, long id) {
        TestCaseFolder folder = this.getOne(id);
        folder.setName(folderPatch.getName());
        folder.setDescription(folderPatch.getDescription());
        if (folderPatch.getCustomFields() != null) {
            List<CustomFieldValueDto> listCufsDto = folderPatch.getCustomFields();
            this.customFieldValueHelper.patchCustomFieldValue((BoundEntity)folder, listCufsDto);
        }
        return folder;
    }

    @Override
    public void deleteFolder(List<Long> folderIds) {
        this.testCaseLibraryNavigationService.deleteNodes(folderIds);
    }

    private void addToParent(TestCaseFolderDto folderDto, TestCaseFolder folder) {
        ParentEntity parent = folderDto.getParent();
        switch (parent.getRestType()) {
            case PROJECT: {
                this.addTestCaseFolderToLibrary(folder, folderDto, parent);
                break;
            }
            case TEST_CASE_FOLDER: {
                this.addTestCaseFolderToFolder(folder, folderDto, parent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Programmatic error : Rest type " + (Object)((Object)parent.getRestType()) + "is not a valid parent. You should validate this before.");
            }
        }
    }

    private void addTestCaseFolderToFolder(TestCaseFolder folder, TestCaseFolderDto folderDto, ParentEntity parent) {
        TestCaseFolder testCaseFolder = (TestCaseFolder)this.entityManager.find(TestCaseFolder.class, (Object)parent.getId());
        if (testCaseFolder == null) {
            throw new IllegalArgumentException("Programmatic error : test case folder with id " + parent.getId() + "is unknown. You should validate this before.");
        }
        this.testCaseLibraryNavigationService.addFolderToFolder(testCaseFolder.getId().longValue(), (Folder)folder);
    }

    private void addTestCaseFolderToLibrary(TestCaseFolder folder, TestCaseFolderDto folderDto, ParentEntity parent) {
        Project project = (Project)this.entityManager.find(Project.class, (Object)parent.getId());
        if (project == null) {
            throw new IllegalArgumentException("Programmatic error : project with id " + parent.getId() + "is unknown. You should validate this before.");
        }
        this.testCaseLibraryNavigationService.addFolderToLibrary(project.getTestCaseLibrary().getId().longValue(), (Folder)folder);
    }
}

