/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.bugtracker.IssueList;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.exception.IssueAlreadyBoundException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;
import org.squashtest.tm.plugin.rest.jackson.model.IssueBugtrackerConnector;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.repository.RestIssueRepository;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.execution.ExecutionProcessingService;
import org.squashtest.tm.service.internal.bugtracker.BugTrackerConnectorFactory;
import org.squashtest.tm.service.internal.bugtracker.adapter.InternalBugtrackerConnector;
import org.squashtest.tm.service.internal.repository.ExecutionDao;

@Service
@Transactional
public class RestIssueServiceImpl
implements RestIssueService {
    private static final List<String> UNSUPPORTED_BUGTRACKER_KINDS = Arrays.asList("gitlab.bugtracker", "azuredevops.bugtracker");
    @Inject
    private RestIssueRepository issueRepository;
    @Inject
    private BugTrackersLocalService bugTrackersLocalService;
    @Inject
    private ExecutionProcessingService executionProcessingService;
    @Inject
    private DSLContext dslContext;
    @Inject
    private BugTrackerConnectorFactory bugTrackerConnectorFactory;
    @Inject
    private BugTrackerFinderService bugTrackerFinderService;
    @Inject
    protected BasePathAwareLinkBuildingService linkService;
    @Inject
    private ExecutionDao executionDao;

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#executionId,'org.squashtest.tm.domain.execution.Execution' , 'WRITE')")
    public Issue attachIssue(IssueDto issueDto, Long executionId) {
        Execution exc = this.executionProcessingService.findExecution(executionId);
        IssueList issueList = exc.getIssueList();
        BugTracker bt = exc.getBugTracker();
        if (UNSUPPORTED_BUGTRACKER_KINDS.contains(bt.getKind())) {
            throw new UnsupportedOperationException("This bugtracker is not supported for this operation");
        }
        if (issueList.hasRemoteIssue(issueDto.getRemoteIssueId())) {
            throw new IssueAlreadyBoundException();
        }
        Issue issue = new Issue();
        issue.setBugtracker(bt);
        issue.setRemoteIssueId(issueDto.getRemoteIssueId());
        issueList.addIssue(issue);
        this.issueRepository.save(issue);
        return issue;
    }

    @Override
    public Page<IssueDto> getIssuesFromExecutionIds(List<Long> executionIds, Pageable pageable) {
        HashMap<Long, IssueBugtrackerConnector> bugtrackerConnectors = new HashMap<Long, IssueBugtrackerConnector>();
        ArrayList<IssueDto> issues = new ArrayList<IssueDto>();
        int pageNumber = pageable.getPageNumber();
        int pageSize = pageable.getPageSize();
        Result result = this.dslContext.select((SelectField)Tables.ISSUE.REMOTE_ISSUE_ID, (SelectField)Tables.ISSUE.BUGTRACKER_ID, (SelectField)DSL.groupConcatDistinct((Field)Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID).as("EXECUTION_IDS")).from((TableLike)Tables.ISSUE).join((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID.eq((Field)Tables.ISSUE.ISSUE_ID)).where(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.in(executionIds)).groupBy(new GroupField[]{Tables.ISSUE.REMOTE_ISSUE_ID, Tables.ISSUE.BUGTRACKER_ID}).fetch();
        Map<Long, Execution> executionMap = this.getLongExecutionMap(executionIds);
        int startIndex = pageNumber * pageSize;
        int endIndex = (pageNumber + 1) * pageSize;
        int count = 0;
        for (Record3 issueRecord : result) {
            if (count >= startIndex && count < endIndex) {
                this.addIssue((Record3<String, Long, String>)issueRecord, bugtrackerConnectors, issues, executionMap);
            }
            ++count;
        }
        return new PageImpl(issues, pageable, (long)result.size());
    }

    private Map<Long, Execution> getLongExecutionMap(List<Long> executionIds) {
        return this.executionDao.findAllById(executionIds).stream().collect(Collectors.toMap(Execution::getId, Function.identity()));
    }

    private void addIssue(Record3<String, Long, String> issueRecord, Map<Long, IssueBugtrackerConnector> bugtrackerConnectors, List<IssueDto> issues, Map<Long, Execution> executionMap) {
        Long bugtrackerId = (Long)issueRecord.get((Field)Tables.ISSUE.BUGTRACKER_ID);
        String remoteIssueId = (String)issueRecord.get((Field)Tables.ISSUE.REMOTE_ISSUE_ID);
        BugTracker bugtracker = bugtrackerConnectors.computeIfAbsent(bugtrackerId, id -> {
            BugTracker existingBugtracker = this.bugTrackerFinderService.findById(id.longValue());
            InternalBugtrackerConnector connector = this.bugTrackerConnectorFactory.createConnector(existingBugtracker);
            return new IssueBugtrackerConnector(existingBugtracker, connector);
        }).bugTracker();
        URL issueUrl = bugtrackerConnectors.get(bugtrackerId).connector().makeViewIssueUrl(bugtracker, remoteIssueId);
        HashSet<Execution> executions = new HashSet<Execution>();
        String[] executionIdsArray = ((String)issueRecord.get("EXECUTION_IDS", String.class)).split(",");
        Arrays.stream(executionIdsArray).map(Long::parseLong).map(executionMap::get).filter(Objects::nonNull).forEach(executions::add);
        boolean remoteIssueAlreadyExists = false;
        boolean urlAlreadyExists = false;
        for (IssueDto issue : issues) {
            if (issue.getRemoteIssueId().equals(remoteIssueId)) {
                remoteIssueAlreadyExists = true;
            }
            if (!issue.getUrl().equals(issueUrl)) continue;
            urlAlreadyExists = true;
        }
        if (!remoteIssueAlreadyExists || !urlAlreadyExists) {
            issues.add(new IssueDto(remoteIssueId, issueUrl, executions));
        }
    }

    @Override
    public Optional<Issue> searchAndAttachIssueToExecution(RemoteIssueSearchRequest searchRequest, Long executionId) {
        return this.bugTrackersLocalService.searchAndAttachIssueToExecution(searchRequest, executionId);
    }
}

