/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.core.utils.ExceptionUtils;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignTestPlanItemDto;
import org.squashtest.tm.plugin.rest.jackson.model.DatasetDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.repository.RestCampaignTestPlanItemRepository;
import org.squashtest.tm.plugin.rest.service.RestCampaignTestPlanItemService;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.CampaignTestPlanItemDao;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.UserDao;

@Service
@Transactional
public class RestCampaignTestPlanItemServiceImpl
implements RestCampaignTestPlanItemService {
    @Inject
    private RestCampaignTestPlanItemRepository ctpiRepository;
    @Inject
    private CampaignDao campaignDao;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private DatasetDao datasetDao;
    @Inject
    private UserDao userDao;
    @Inject
    private CampaignTestPlanItemDao campaignTestPlanItemDao;
    @Inject
    private CampaignTestPlanManagerService campaignTestPlanManagerService;

    @Override
    @PostAuthorize(value="hasPermission(returnObject , 'READ') or hasRole('ROLE_ADMIN')")
    @Transactional(readOnly=true)
    public CampaignTestPlanItem getOne(long id) {
        return (CampaignTestPlanItem)this.ctpiRepository.findById(id).orElseThrow(() -> ExceptionUtils.entityNotFoundException(CampaignTestPlanItem.class, (Long)id));
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#campaignId,'org.squashtest.tm.domain.campaign.Campaign' , 'LINK')")
    public CampaignTestPlanItem addTestCaseToCampaign(CampaignTestPlanItemDto ctpiDto, Long campaignId) {
        TestCaseDto referencedTcDTo = ctpiDto.getReferencedTestCase();
        DatasetDto referencedDatasetDto = ctpiDto.getReferencedDataset();
        Campaign campaign = (Campaign)this.campaignDao.findById(campaignId.longValue());
        TestCase testCase = (TestCase)this.testCaseDao.findById(referencedTcDTo.getId().longValue());
        User assignedTo = ctpiDto.getUser() != null ? this.userDao.findUserByLogin(ctpiDto.getUser()) : null;
        Dataset ds = referencedDatasetDto != null ? (Dataset)this.datasetDao.getReferenceById((Object)referencedDatasetDto.getId()) : null;
        CampaignTestPlanItem ctpi = new CampaignTestPlanItem(testCase, ds);
        ctpi.setUser(assignedTo);
        campaign.addToTestPlan(ctpi);
        this.campaignTestPlanItemDao.persist((Object)ctpi);
        return ctpi;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#testPlanId,'org.squashtest.tm.domain.campaign.CampaignTestPlanItem' , 'WRITE')")
    public CampaignTestPlanItem modifyCampaignTestPlan(CampaignTestPlanItemDto ctpiDto, Long testPlanId) {
        User assignedTo;
        CampaignTestPlanItem ctpi = (CampaignTestPlanItem)this.campaignTestPlanItemDao.findById(testPlanId.longValue());
        Dataset ds = ctpiDto.getReferencedDataset() != null ? (Dataset)this.datasetDao.getReferenceById((Object)ctpiDto.getReferencedDataset().getId()) : null;
        User user = assignedTo = ctpiDto.getUser() != null ? this.userDao.findUserByLogin(ctpiDto.getUser()) : null;
        if (ctpiDto.isHasSetDataset()) {
            ctpi.setReferencedDataset(ds);
        }
        if (ctpiDto.isAssignedTo()) {
            ctpi.setUser(assignedTo);
        }
        return ctpi;
    }

    @Override
    public void deleteCampaignTestPlan(List<Long> testPlanIds) {
        List<Couple<Long, Long>> listIds = this.ctpiRepository.findCampaignByIdItem(testPlanIds);
        Map mapItpi = listIds.stream().collect(Collectors.groupingBy(Couple::getA1, Collectors.mapping(Couple::getA2, Collectors.toList())));
        mapItpi.forEach((k, v) -> this.campaignTestPlanManagerService.removeTestPlanItems(k.longValue(), v));
    }
}

