/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.jackson.model.CampaignDto;
import org.squashtest.tm.plugin.rest.jackson.model.ParentEntity;
import org.squashtest.tm.plugin.rest.repository.RestCampaignRepository;
import org.squashtest.tm.plugin.rest.repository.RestCampaignTestPlanItemRepository;
import org.squashtest.tm.plugin.rest.repository.RestIterationRepository;
import org.squashtest.tm.plugin.rest.service.RestCampaignService;
import org.squashtest.tm.plugin.rest.service.RestInternalCustomFieldValueUpdaterService;
import org.squashtest.tm.plugin.rest.service.helper.CustomFieldValueHelper;
import org.squashtest.tm.plugin.rest.service.impl.CampaignPatcher;
import org.squashtest.tm.plugin.rest.utils.PaginationUtils;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.CampaignModificationService;
import org.squashtest.tm.service.internal.repository.CustomItpiLastExecutionFilterDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateCampaignDao;
import org.squashtest.tm.service.project.ProjectFinder;

@Service
@Transactional
public class RestCampaignServiceImpl
implements RestCampaignService {
    @Inject
    private RestCampaignRepository campaignRepository;
    @Inject
    private RestIterationRepository iterationRepository;
    @Inject
    private RestCampaignTestPlanItemRepository ctpiRepository;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private CampaignLibraryNavigationService campaignLibraryNavigationService;
    @Inject
    private CampaignModificationService campaignModificationService;
    @Inject
    private CustomFieldValueHelper customFieldValueConverter;
    @Inject
    private CampaignPatcher campaignPatcher;
    @Inject
    private RestInternalCustomFieldValueUpdaterService internalCufService;
    @Inject
    private DSLContext dslContext;
    @Inject
    private CustomItpiLastExecutionFilterDao itpiLastExecutionFilterDao;
    @Inject
    private HibernateCampaignDao hibernateCampaignDao;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ')")
    public Campaign getOne(Long campaignId) {
        return (Campaign)this.campaignRepository.getReferenceById(campaignId);
    }

    @Override
    public Campaign createCampaign(CampaignDto campaignDto) {
        Campaign campaign = new Campaign();
        campaign.setName(campaignDto.getName());
        this.campaignPatcher.patch(campaign, campaignDto);
        campaign.setActualStartAuto(campaignDto.isActualStartAuto());
        campaign.setActualEndAuto(campaignDto.isActualEndAuto());
        Map<Long, RawValue> customFieldRawValues = this.customFieldValueConverter.convertCustomFieldDtoToMap(campaignDto.getCustomFields());
        ParentEntity parent = campaignDto.getParent();
        switch (parent.getRestType()) {
            case PROJECT: {
                this.campaignLibraryNavigationService.addCampaignToCampaignLibrary(parent.getId().longValue(), campaign, customFieldRawValues);
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.campaignLibraryNavigationService.addCampaignToCampaignFolder(parent.getId().longValue(), campaign, customFieldRawValues);
                break;
            }
            default: {
                throw new IllegalArgumentException("Programmatic error : Rest type " + (Object)((Object)parent.getRestType()) + "is not a valid parent. You should validate this before.");
            }
        }
        this.fillTimePeriod(campaignDto, campaign.getId());
        return campaign;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#id,'org.squashtest.tm.domain.campaign.Campaign' , 'WRITE')")
    public Campaign patchCampaign(CampaignDto campaignDto, long id) {
        Campaign campaign = this.getOne(id);
        if (StringUtils.isNotBlank((CharSequence)campaignDto.getName())) {
            this.campaignModificationService.rename(campaign.getId().longValue(), campaignDto.getName());
        }
        this.campaignPatcher.patch(campaign, campaignDto);
        this.fillTimePeriod(campaignDto, campaign.getId());
        this.internalCufService.mergeCustomFields((BoundEntity)campaign, campaignDto.getCustomFields());
        return campaign;
    }

    @Override
    public void deleteCampaignsByIds(List<Long> campaignIds) {
        this.campaignLibraryNavigationService.deleteNodes(campaignIds);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Campaign> findAllReadable(Pageable pageable) {
        List projectIds = this.projectFinder.findReadableProjectIdsOnCampaignLibrary();
        return projectIds.isEmpty() ? PaginationUtils.emptyPage(pageable) : this.campaignRepository.findAllInProjects(projectIds, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ')")
    public Page<Iteration> findIterations(long campaignId, Pageable pageable) {
        return this.iterationRepository.findAllByCampaign_Id(campaignId, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ')")
    public Page<CampaignTestPlanItem> findTestPlan(long campaignId, Pageable pageable) {
        return this.ctpiRepository.findAllByCampaign_Id(campaignId, pageable);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Campaign> findAllByName(String campaignName, Pageable pageable) {
        Page<Campaign> campaign = this.campaignRepository.findAllByName(campaignName, pageable);
        if (Objects.isNull(campaign)) {
            throw new EntityNotFoundException("Unable to find org.squashtest.tm.domain.campaign.Campaign with name " + campaignName);
        }
        return campaign;
    }

    private void fillTimePeriod(CampaignDto campaignDto, long campaignId) {
        if (campaignDto.getScheduledStartDate() != null) {
            this.campaignModificationService.changeScheduledStartDate(campaignId, campaignDto.getScheduledStartDate());
        }
        if (campaignDto.getScheduledEndDate() != null) {
            this.campaignModificationService.changeScheduledEndDate(campaignId, campaignDto.getScheduledEndDate());
        }
        if (campaignDto.getActualStartDate() != null) {
            this.campaignModificationService.changeActualStartDate(campaignId, campaignDto.getActualStartDate());
        }
        if (campaignDto.getActualEndDate() != null) {
            this.campaignModificationService.changeActualEndDate(campaignId, campaignDto.getActualEndDate());
        }
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'READ')")
    public List<Long> getExecutionIdsByCampaign(Long campaignId) {
        return this.dslContext.select((SelectField)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID).from((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).join((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).fetchInto(Long.class);
    }

    @Override
    public TestPlanStatistics getCampaignTestPlanStatistics(long campaignId) {
        List itpiIdsInTCLastExecScope = this.itpiLastExecutionFilterDao.gatherLatestItpiIdsForTCInScopeForCampaign(Collections.singletonList(campaignId));
        return this.hibernateCampaignDao.findCampaignStatisticsForTCLastExecutionScope(campaignId, itpiIdsInTCLastExecScope);
    }
}

