/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.plugin.rest.repository.RestAutomatedSuiteRepository;
import org.squashtest.tm.plugin.rest.service.RestAutomatedSuiteService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.testautomation.AutomatedSuiteManagerService;
import org.squashtest.tm.service.testautomation.testplanretriever.RestTestPlanFinder;

@Service
@Transactional
public class RestAutomatedSuiteServiceImpl
implements RestAutomatedSuiteService {
    @Inject
    private AutomatedSuiteManagerService automatedSuiteManagerService;
    @Inject
    private RestAutomatedSuiteRepository suiteRepository;
    @Inject
    private IterationTestPlanManagerService iterationTestPlanManagerService;
    @Inject
    private RestTestPlanFinder testPlanFinder;

    @Override
    public AutomatedSuite findById(String id) {
        return this.automatedSuiteManagerService.findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<AutomatedSuite> findAllReadable(Pageable pageable) {
        return this.suiteRepository.findAll(pageable);
    }

    @Override
    public AutomatedSuite createAutomatedSuiteFromIteration(long iterationId) {
        List itemIds = this.testPlanFinder.getItemTestPlanIdsByIterationId(Long.valueOf(iterationId));
        return this.automatedSuiteManagerService.createFromIterationTestPlan(iterationId, itemIds);
    }

    @Override
    public AutomatedSuite createAutomatedSuiteFromTestSuite(long testSuiteId) {
        List itemIds = this.testPlanFinder.getItemTestPlanIdsByTestSuiteId(Long.valueOf(testSuiteId));
        return this.automatedSuiteManagerService.createFromTestSuiteTestPlan(testSuiteId, itemIds);
    }

    @Override
    public AutomatedSuite createAutomatedSuiteFromIterationTestPlanItems(List<Long> itemIds) {
        IterationTestPlanItem item = this.iterationTestPlanManagerService.findTestPlanItem(itemIds.get(0).longValue());
        return this.automatedSuiteManagerService.createFromItemsAndIteration(itemIds, item.getIteration().getId().longValue());
    }

    @Override
    public void start(AutomatedSuite suite) {
        this.automatedSuiteManagerService.start(suite);
    }
}

