/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.helper;

import org.apache.commons.io.FilenameUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.squashtest.tm.event.ConfigUpdateEvent;
import org.squashtest.tm.service.attachment.RawAttachment;
import org.squashtest.tm.service.configuration.ConfigurationService;

@Component
public class AttachmentContentFilterHelper
implements ApplicationListener<ApplicationEvent> {
    private ConfigurationService config;
    private String[] allowed;
    private String whiteListKey = "uploadfilter.fileExtensions.whitelist";

    private void updateConfig() {
        String whiteList = this.config.findConfiguration(this.whiteListKey);
        this.allowed = whiteList.split(",");
    }

    public boolean isTypeAllowed(RawAttachment upload) {
        String fileType = FilenameUtils.getExtension((String)upload.getName());
        String[] stringArray = this.allowed;
        int n = this.allowed.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.trim().equalsIgnoreCase(fileType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent && this.config == null) {
            this.config = (ConfigurationService)((ContextRefreshedEvent)event).getApplicationContext().getBean(ConfigurationService.class);
        }
        if (event instanceof ConfigUpdateEvent || event instanceof ContextRefreshedEvent) {
            this.updateConfig();
        }
    }
}

