/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.RestPartyClearance;
import org.squashtest.tm.plugin.rest.jackson.model.RestUserPermission;
import org.squashtest.tm.plugin.rest.jackson.model.UserDto;
import org.squashtest.tm.plugin.rest.service.RestPartyService;
import org.squashtest.tm.plugin.rest.service.RestProjectService;
import org.squashtest.tm.plugin.rest.validators.PartyPatchValidator;
import org.squashtest.tm.plugin.rest.validators.PartyPostValidator;

@RestApiController(value=User.class)
@UseDefaultRestApiConfiguration
public class RestUserController
extends BaseRestController {
    @Inject
    private RestPartyService restPartyService;
    @Inject
    private PartyPostValidator partyPostValidator;
    @Inject
    private PartyPatchValidator partyPatchValidator;
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private RestProjectService restProjectService;

    @GetMapping(value={"/users/{id}"})
    @EntityGetter
    @DynamicFilterExpression(value="*, teams[*, -members], audit[*]")
    public ResponseEntity<EntityModel<User>> findUser(@PathVariable(value="id") long userId) {
        User user = this.restPartyService.findUserByPartyId(userId);
        EntityModel res = this.toEntityModel((Identified)user);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/users"})
    @ResponseBody
    @DynamicFilterExpression(value="login, active, group")
    public ResponseEntity<PagedModel<EntityModel<User>>> findAllUsers(Pageable pageable) {
        Page<User> pagedUsers = this.restPartyService.findAllUsers(pageable);
        PagedModel res = this.toPagedModel(pagedUsers);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/users"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<User>> createUser(@RequestBody UserDto userDto) throws BindException {
        this.validatePostUser(userDto);
        User user = (User)this.restPartyService.createParty(userDto);
        EntityModel res = this.toEntityModel((Identified)user);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/users/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, teams[*, -members]")
    public ResponseEntity<EntityModel<User>> patchUser(@RequestBody UserDto patch, @PathVariable(value="id") long id) throws BindException {
        patch.setId(id);
        this.validatePatchUser(patch);
        User user = (User)this.restPartyService.patchParty(patch, id);
        EntityModel res = this.toEntityModel((Identified)user);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/users/{ids}"})
    public ResponseEntity<Void> deleteUsers(@PathVariable(value="ids") List<Long> userIds) {
        this.restPartyService.deleteUsers(userIds);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/users/{userId}/teams"})
    @ResponseBody
    @DynamicFilterExpression(value="*, -members")
    public ResponseEntity<PagedModel<EntityModel<Team>>> findTeams(@PathVariable(value="userId") long userId, Pageable pageable) {
        Page<Team> teams = this.restPartyService.findTeamsByUser(userId, pageable);
        PagedModel res = this.toPagedModel(teams);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/users/{userId}/teams"})
    public ResponseEntity<Object> addTeamsToUser(@PathVariable(value="userId") long userId, @RequestParam(value="teamIds") List<Long> teamIds) {
        Set<String> failedTeams = this.restPartyService.addTeamsToUser(userId, teamIds);
        if (failedTeams.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        String warningMessage = "The following teams could not be added: " + String.join((CharSequence)", ", failedTeams);
        return ResponseEntity.status((HttpStatus)HttpStatus.PARTIAL_CONTENT).body((Object)warningMessage);
    }

    @DeleteMapping(value={"/users/{userId}/teams"})
    public ResponseEntity<Void> disassociateUserFromTeams(@PathVariable(value="userId") long userId, @RequestParam(value="teamIds") List<Long> teamIds) {
        this.restPartyService.disassociateUserFromTeams(userId, teamIds);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/users/{userId}/clearances"})
    public ResponseEntity<EntityModel<RestPartyClearance>> getClearancesForGivenUser(@PathVariable(value="userId") long userId) {
        RestPartyClearance clearances = this.restPartyService.getAllClearancesForGivenUser(userId);
        EntityModel res = EntityModel.of((Object)clearances);
        this.linksHelper.addAllLinksForUserClearance(userId, (EntityModel<RestPartyClearance>)res);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/users/{userId}/permissions"})
    public ResponseEntity<EntityModel<RestUserPermission>> getPermissionForGivenUser(@PathVariable(value="userId") long userId) {
        RestUserPermission restUserPermission = this.restPartyService.getAllPermissionsForGivenUser(userId);
        EntityModel res = EntityModel.of((Object)restUserPermission);
        this.linksHelper.addAllLinksForUserPermission(userId, (EntityModel<RestUserPermission>)res);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/users/{userId}/clearances/{profileId}/projects/{projectIds}"})
    public ResponseEntity<EntityModel<RestPartyClearance>> addClearanceToGivenUser(@PathVariable(value="userId") long userId, @PathVariable(value="profileId") long profileId, @PathVariable(value="projectIds") List<Long> projectIds) {
        this.restPartyService.addClearanceToUser(userId, projectIds, profileId);
        return this.getClearancesForGivenUser(userId);
    }

    @PostMapping(value={"/users/{userId}/permissions/{permissionGroup}"})
    public ResponseEntity<EntityModel<RestUserPermission>> addPermissionToGivenUser(@PathVariable(value="userId") long userId, @PathVariable(value="permissionGroup") String permissionGroup, @RequestParam(value="ids") List<Long> projectIds) throws BindException {
        PostUserPermissionModel bean = new PostUserPermissionModel(projectIds, permissionGroup);
        this.validatePostNewPermissionsToUser(bean);
        this.restPartyService.addPermissionToUser(userId, projectIds, bean.permissionGroup);
        return this.getPermissionForGivenUser(userId);
    }

    @DeleteMapping(value={"/users/{userId}/clearances/{projectIds}"})
    public ResponseEntity<Void> removeClearanceToUser(@PathVariable(value="userId") long userId, @PathVariable(value="projectIds") List<Long> projectIds) {
        this.restPartyService.removePermissionToUser(userId, projectIds);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/users/{userId}/permissions"})
    public ResponseEntity<Void> removePermissionToUser(@PathVariable(value="userId") long userId, @RequestParam(value="ids") List<Long> projectIds) {
        this.restPartyService.removePermissionToUser(userId, projectIds);
        return ResponseEntity.noContent().build();
    }

    private void validatePatchUser(UserDto patch) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)patch, "patch-user");
        this.partyPatchValidator.validate(patch, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(patch, errors, "patch-user");
    }

    private void validatePostUser(UserDto userDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)userDto, "post-user");
        this.partyPostValidator.validate(userDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(userDto, errors, "post-user");
    }

    private void validatePostNewPermissionsToUser(PostUserPermissionModel bean) throws BindException {
        String message;
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)bean, "post-user-permission");
        int index = 0;
        for (Long projectId : bean.projectIds) {
            if (!this.restProjectService.isGenericProjectExist(projectId).booleanValue()) {
                message = String.format("the project with the id %d doesn't exit", projectId);
                String fieldName = String.format("ids[%d]", index);
                validation.rejectValue(fieldName, "invalid ids for project", message);
                errors.add((Errors)validation);
                validation = new BeanPropertyBindingResult((Object)bean, "post-user-permission");
            }
            ++index;
        }
        String permissionGroupName = bean.permissionGroup;
        if ("advanced_tester".equals(bean.permissionGroup)) {
            bean.permissionGroup = "advance_tester";
        }
        bean.permissionGroup = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, bean.permissionGroup);
        if (!this.getAllPermissionGroups().contains(bean.permissionGroup)) {
            String permissionGroupNames = this.getAllPermissionGroupsInString();
            message = String.format("No permission group known for %s. Options available : %s", permissionGroupName, permissionGroupNames);
            validation.rejectValue("permissionGroup", "invalid permission group", message);
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(bean, errors, "post-user-permission");
    }

    private List<String> getAllPermissionGroups() {
        List<AclGroup> groups = this.restProjectService.findAllPossiblePermission();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (AclGroup group : groups) {
            groupNames.add(group.getSimpleName());
        }
        return groupNames;
    }

    private String getAllPermissionGroupsInString() {
        return this.getAllPermissionGroups().stream().map(val -> "advanceTester".equalsIgnoreCase((String)val) ? "advancedTester" : val).map(pg -> CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, pg)).collect(Collectors.joining(","));
    }

    private class PostUserPermissionModel {
        private List<Long> projectIds;
        private String permissionGroup;

        public PostUserPermissionModel(List<Long> projectIds, String permissionGroup) {
            this.projectIds = projectIds;
            this.permissionGroup = permissionGroup;
        }

        public List<Long> getProjectIds() {
            return this.projectIds;
        }

        public String getPermissionGroup() {
            return this.permissionGroup;
        }
    }
}

