/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.service.RestTestAutomationServerService;

@RestApiController(value=TestAutomationServer.class)
@UseDefaultRestApiConfiguration
public class RestTestAutomationServerController
extends BaseRestController {
    @Inject
    private RestTestAutomationServerService serverService;

    @GetMapping(value={"/test-automation-servers/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<TestAutomationServer>> findTestAutomationServer(@PathVariable(value="id") long serverId) {
        TestAutomationServer server = this.serverService.getOne(serverId);
        EntityModel res = this.toEntityModel((Identified)server);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/test-automation-servers"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<PagedModel<EntityModel<TestAutomationServer>>> findAllReadableTestAutomationServer(Pageable pageable) {
        Page<TestAutomationServer> tcs = this.serverService.findAllReadable(pageable);
        PagedModel res = this.toPagedModel(tcs);
        return ResponseEntity.ok((Object)res);
    }
}

