/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import javax.inject.Inject;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.service.RestSprintService;

@RestApiController(value=Sprint.class)
@UseDefaultRestApiConfiguration
public class RestSprintController
extends BaseRestController {
    @Inject
    private RestSprintService sprintService;

    @GetMapping(value={"/sprints/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="id, name")
    public ResponseEntity<EntityModel<Sprint>> findSprint(@PathVariable(value="id") long id) {
        Sprint sprint = this.sprintService.getOne(id);
        EntityModel entityModel = this.toEntityModel((Identified)sprint);
        entityModel.add(this.linkService.createLinkTo((Identified)sprint.getProject()));
        return ResponseEntity.ok((Object)entityModel);
    }
}

