/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementVersionDto;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.plugin.rest.service.RestRequirementVersionService;
import org.squashtest.tm.plugin.rest.service.RestVerifyingTestCaseManagerService;
import org.squashtest.tm.plugin.rest.validators.RequirementVersionValidator;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;

@RestApiController(value=RequirementVersion.class)
@UseDefaultRestApiConfiguration
public class RestRequirementVersionController
extends BaseRestController {
    @Inject
    private RestRequirementVersionService service;
    @Inject
    private RequirementVersionValidator requirementVersionValidator;
    @Inject
    private RestVerifyingTestCaseManagerService verifyingTestCaseManager;
    @Inject
    private RestIssueService restIssueService;
    @Inject
    private RequirementVersionManagerService requirementVersionManagerService;

    @ResponseBody
    @GetMapping(value={"/requirement-versions/{id}"})
    @DynamicFilterExpression(value="*, requirement[name], verifying_test_cases[name]")
    @EntityGetter
    public ResponseEntity<EntityModel<RequirementVersion>> findRequirementVersion(@PathVariable(value="id") long id) {
        RequirementVersion reqVersion = this.service.findRequirementVersion(id);
        EntityModel res = this.toEntityModel((Identified)reqVersion);
        res.add(this.linkService.createLinkTo((Identified)reqVersion.getProject()));
        res.add(this.linkService.createLinkTo((Identified)reqVersion.getRequirement()));
        res.add(this.linkService.createRelationTo((Identified)reqVersion, "attachments"));
        res.add(this.createRelationTo("issues"));
        return ResponseEntity.ok((Object)res);
    }

    @ResponseBody
    @PostMapping(value={"/requirement-versions/{reqId}"})
    @DynamicFilterExpression(value="*, requirement[name], verifying_test_cases[name]")
    public ResponseEntity<EntityModel<RequirementVersion>> createRequirementVersion(@PathVariable(value="reqId") long id, @RequestParam(value="req_link", required=false, defaultValue="false") boolean inheritReqLinks, @RequestParam(value="tc_req_link", required=false, defaultValue="false") boolean inheritTestcasesReqLinks) throws BindException {
        this.requirementVersionValidator.validatePostRequirementVersion(id);
        RequirementVersion newlyCreatedRequirementVersion = this.service.createRequirementVersion(id, inheritReqLinks, inheritTestcasesReqLinks);
        return this.findRequirementVersion(newlyCreatedRequirementVersion.getId());
    }

    @ResponseBody
    @PatchMapping(value={"/requirement-versions/{reqVersionId}"})
    @DynamicFilterExpression(value="*, requirement[name], verifying_test_cases[name]")
    public ResponseEntity<EntityModel<RequirementVersion>> modifyRequirementVersion(@PathVariable(value="reqVersionId") long id, @RequestBody RequirementVersionDto requirementVersionDto) throws BindException {
        RequirementVersion reqVersion = this.service.findRequirementVersion(id);
        this.requirementVersionValidator.validatePatchRequirementVersion(requirementVersionDto, reqVersion.getRequirement().getId());
        RequirementVersion newlyCreatedRequirementVersion = this.service.modifyRequirementVersion(requirementVersionDto, id);
        return this.findRequirementVersion(newlyCreatedRequirementVersion.getId());
    }

    @ResponseBody
    @PostMapping(value={"/requirement-versions/{id}/coverages/{testCaseIds}"})
    @DynamicFilterExpression(value="*, requirement[name], verifying_test_cases[name]")
    public ResponseEntity<EntityModel<RequirementVersion>> associateTestCases(@PathVariable(value="id") Long requirementVersionId, @PathVariable(value="testCaseIds") List<Long> testCaseIds) throws BindException {
        this.requirementVersionValidator.validateAssociateTestCases(requirementVersionId, testCaseIds);
        this.verifyingTestCaseManager.addVerifyingTestCasesToRequirementVersion(testCaseIds, requirementVersionId);
        return this.findRequirementVersion(requirementVersionId);
    }

    @DeleteMapping(value={"/requirement-versions/{id}/coverages/{testCaseIds}"})
    public ResponseEntity<Void> removeVerifyingTestCasesFromRequirement(@PathVariable(value="id") Long requirementVersionId, @PathVariable(value="testCaseIds") List<Long> testCaseIds) throws BindException {
        this.requirementVersionValidator.validateDisassociateTestCases(requirementVersionId, testCaseIds);
        this.verifyingTestCaseManager.removeVerifyingTestCasesToRequirementVersion(testCaseIds, requirementVersionId);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/requirement-versions/{id}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="executions[id], requirements[id]")
    public ResponseEntity<PagedModel<EntityModel<IssueDto>>> findRequirementVersionIssues(@PathVariable(value="id") long id, Pageable pageable) {
        List<Long> executionIds = this.service.getExecutionIdsByRequirementVersion(id);
        Page<IssueDto> pagedIssue = this.restIssueService.getIssuesFromExecutionIds(executionIds, pageable);
        for (IssueDto issue : pagedIssue.getContent()) {
            Set<Execution> executions = issue.getExecutions();
            if (executions == null) continue;
            List allValues = issue.getExecutions().stream().map(execution -> this.service.getRequirementVersionFromIssue(issue.getRemoteIssueId(), execution.getId())).flatMap(Collection::stream).distinct().toList();
            HashSet encounteredIds = new HashSet();
            List<RequirementVersion> filteredList = allValues.stream().filter(reqVer -> encounteredIds.add(reqVer.getId())).toList();
            issue.setRequirements(new HashSet<RequirementVersion>(filteredList));
        }
        PagedModel res = this.pageAssembler.toModel(pagedIssue);
        return ResponseEntity.ok((Object)res);
    }
}

