/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchTerm;
import org.squashtest.tm.bugtracker.advanceddomain.exception.InvalidRemoteIssueSearchRequestException;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.exception.IssueAlreadyBoundException;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.core.web.exceptionhandler.response.DetailedJsonError;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.service.RestIssueService;

@RestApiController(value=Issue.class)
@Validated
@UseDefaultRestApiConfiguration
public class RestIssueController
extends BaseRestController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestIssueController.class);
    @Inject
    private RestIssueService restIssueService;

    @GetMapping(value={"/issues/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<Issue>> findCampaign(@PathVariable(value="id") long id) {
        throw new UnsupportedOperationException("This service is not available yet.");
    }

    @PostMapping(value={"/executions/{executionId}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<Issue>> attachIssueToExecution(@PathVariable(value="executionId") long executionId, @RequestBody IssueDto issueDto) throws UnsupportedOperationException {
        Issue issue = this.restIssueService.attachIssue(issueDto, executionId);
        EntityModel res = this.toEntityModel((Identified)issue);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @PostMapping(value={"/executions/{executionId}/attach-issue"})
    @ResponseBody
    @DynamicFilterExpression
    public ResponseEntity<Object> searchAndAttachIssueToExecution(@PathVariable(value="executionId") long executionId, @Valid @RequestBody FindIssueRequestBody request) {
        try {
            Optional<Issue> issue = this.restIssueService.searchAndAttachIssueToExecution(request.toSearchRequest(), executionId);
            if (issue.isEmpty()) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new DetailedJsonError(HttpStatus.NOT_FOUND.value(), HttpStatus.NOT_FOUND.getReasonPhrase(), "The item could not be found"));
            }
            EntityModel res = this.toEntityModel((Identified)issue.get());
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
        }
        catch (InvalidRemoteIssueSearchRequestException | IssueAlreadyBoundException e) {
            LOGGER.error("Cannot link issue", e);
            return ResponseEntity.badRequest().body((Object)new DetailedJsonError(HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), e.getMessage()));
        }
    }

    public record FindIssueRequestBody(Map<String, String> values) {
        public RemoteIssueSearchRequest toSearchRequest() {
            List<RemoteIssueSearchTerm> searchTerms = this.values.entrySet().stream().map(entry -> new RemoteIssueSearchTerm((String)entry.getKey(), (String)entry.getValue())).toList();
            return new RemoteIssueSearchRequest(searchTerms);
        }
    }
}

