/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.users.ApiToken;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.ApiTokenRestDto;
import org.squashtest.tm.plugin.rest.service.RestApiTokenService;
import org.squashtest.tm.plugin.rest.validators.ApiTokenPostValidator;
import org.squashtest.tm.service.internal.dto.ApiTokenDto;

@RestApiController(value=ApiToken.class)
@UseDefaultRestApiConfiguration
@Validated
public class RestApiTokenController
extends BaseRestController {
    @Inject
    private RestApiTokenService restApiTokenService;
    @Inject
    private ApiTokenPostValidator apiTokenPostValidator;

    @DeleteMapping(value={"/tokens/self"})
    @ResponseBody
    public ResponseEntity<String> selfDestroyApiToken(@RequestHeader(value="Authorization", required=false) String authorizationHeader) {
        if (authorizationHeader == null || !authorizationHeader.startsWith("Bearer ")) {
            return new ResponseEntity((Object)"Token not provided", HttpStatus.UNAUTHORIZED);
        }
        String token = authorizationHeader.substring(7);
        this.restApiTokenService.selfDestroyToken(token);
        return new ResponseEntity((Object)"Token invalidated", HttpStatus.OK);
    }

    @GetMapping(value={"/tokens"})
    @ResponseBody
    @EntityGetter
    public ResponseEntity<PagedModel<EntityModel<ApiToken>>> getAllTokensByUser(Pageable pageable) {
        Page<ApiToken> pagedApiTokens = this.restApiTokenService.getAllTokensByUser(pageable);
        PagedModel res = this.toPagedModel(pagedApiTokens);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/tokens/{id}"})
    public ResponseEntity<String> deletePersonalApiToken(@PathVariable(value="id") long tokenId) {
        this.restApiTokenService.deletePersonalApiToken(tokenId);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/tokens"})
    @ResponseBody
    @DynamicFilterExpression(value="*,name,api_token[name]")
    public ResponseEntity<ApiTokenRestDto> postApiToken(@RequestBody @Valid ApiTokenRestDto apiTokenRestDto) throws BindException {
        this.validatePostApiToken(apiTokenRestDto);
        ApiTokenDto apiTokenDto = this.restApiTokenService.addToken(apiTokenRestDto);
        apiTokenRestDto.setGeneratedToken(apiTokenDto.generatedJwtToken());
        apiTokenRestDto.setId(apiTokenDto.squashApiToken().getId());
        apiTokenRestDto.setUser(apiTokenDto.squashApiToken().getUser());
        apiTokenRestDto.setCreatedOn(apiTokenDto.squashApiToken().getCreatedOn());
        apiTokenRestDto.setCreatedBy(apiTokenDto.squashApiToken().getCreatedBy());
        apiTokenRestDto.setUuid(apiTokenDto.squashApiToken().getUuid());
        apiTokenRestDto.setLastUsage(apiTokenDto.squashApiToken().getLastUsage());
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)apiTokenRestDto);
    }

    private void validatePostApiToken(ApiTokenRestDto apiTokenRestDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)apiTokenRestDto, "post-api-token");
        this.apiTokenPostValidator.validate(apiTokenRestDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(apiTokenRestDto, errors, "post-api-token");
    }
}

