/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.premium.actionword.dao;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.domain.bdd.QActionWord;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQueryFactory;
import org.squashtest.tm.domain.testcase.QKeywordTestStep;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.domain.tf.automationrequest.QAutomationRequest;
import org.squashtest.tm.plugin.premium.service.UltimateLicenseChecker;
import org.squashtest.tm.service.internal.helper.PagingToQueryDsl;
import org.squashtest.tm.service.internal.repository.UsingTestCaseDao;

@Repository
@Transactional
public class UsingTestCaseDaoImpl
implements UsingTestCaseDao {
    private static final String AUTOMATABLE = "automatable";
    private static final String IMPORTANCE = "importance";
    private static final String AUTOMATION_REQUEST_REQUEST_STATUS = "automationRequest.requestStatus";
    @Inject
    private EntityManager entityManager;
    @Inject
    private UltimateLicenseChecker ultimateLicenseChecker;

    public List<TestCase> findAllByActionWord(long id) {
        this.ultimateLicenseChecker.checkIfAvailable();
        HibernateQuery<TestCase> baseQuery = this.createBaseQuery(id);
        return baseQuery.fetch();
    }

    public Page<TestCase> findPageByActionWord(long id, Pageable pageable, ColumnFiltering filtering) {
        this.ultimateLicenseChecker.checkIfAvailable();
        HibernateQuery<TestCase> baseQuery = this.createBaseQuery(id);
        Predicate predicate = this.toQueryDslPredicate(filtering);
        baseQuery.where(predicate);
        List usingTestCases = this.findUsingTestCases(baseQuery, pageable).stream().distinct().collect(Collectors.toList());
        long count = this.countUsingTestCases(baseQuery);
        return new PageImpl(usingTestCases, pageable, count);
    }

    private HibernateQuery<TestCase> createBaseQuery(long actionWordId) {
        QActionWord actionWord = QActionWord.actionWord;
        QKeywordTestStep keywordTestStep = QKeywordTestStep.keywordTestStep;
        QTestCase testCase = QTestCase.testCase;
        QAutomationRequest automationRequest = QAutomationRequest.automationRequest;
        return (HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)new ExtendedHibernateQueryFactory(this.getSession()).select((Expression)testCase).from((EntityPath)actionWord)).join((CollectionExpression)actionWord.keywordTestSteps, (Path)keywordTestStep)).join((EntityPath)keywordTestStep.testCase, (Path)testCase)).leftJoin((EntityPath)testCase.automationRequest, (Path)automationRequest)).where((Predicate)actionWord.id.eq((Object)actionWordId));
    }

    private Predicate toQueryDslPredicate(ColumnFiltering filtering) {
        return new PagingToQueryDsl.ColumnFilteringConverter(TestCase.class).from(filtering).build();
    }

    private List<TestCase> findUsingTestCases(HibernateQuery<TestCase> baseQuery, Pageable pageable) {
        Sort originalSort;
        HibernateQuery fetchUsingTestCasesQuery = (HibernateQuery)baseQuery.clone();
        ((HibernateQuery)fetchUsingTestCasesQuery.offset(pageable.getOffset())).limit((long)pageable.getPageSize());
        Sort newSort = originalSort = pageable.getSort();
        if (originalSort.getOrderFor(AUTOMATION_REQUEST_REQUEST_STATUS) != null) {
            newSort = this.appendAutomatableSorting(originalSort);
        }
        OrderSpecifier[] orderSpecifiers = this.toQueryDslSorting(newSort);
        fetchUsingTestCasesQuery.orderBy(orderSpecifiers);
        return fetchUsingTestCasesQuery.fetch();
    }

    private Sort appendAutomatableSorting(Sort originalSort) {
        Sort.Order originalOrder = (Sort.Order)originalSort.stream().findAny().get();
        Sort.Order automatableOrder = new Sort.Order(this.getOppositeDirection(originalSort.getOrderFor(AUTOMATION_REQUEST_REQUEST_STATUS).getDirection()), AUTOMATABLE);
        return Sort.by((Sort.Order[])new Sort.Order[]{automatableOrder, originalOrder});
    }

    private Sort.Direction getOppositeDirection(Sort.Direction direction) {
        return switch (direction) {
            case Sort.Direction.DESC -> Sort.Direction.ASC;
            case Sort.Direction.ASC -> Sort.Direction.DESC;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private OrderSpecifier[] toQueryDslSorting(Sort sort) {
        return ((PagingToQueryDsl.SortConverter)((PagingToQueryDsl.SortConverter)((PagingToQueryDsl.SortConverter)((PagingToQueryDsl.SortConverter)PagingToQueryDsl.sortConverter(TestCase.class).from(sort).typeFor(new String[]{IMPORTANCE}).isClass(TestCaseImportance.class)).typeFor(new String[]{"STATUS"}).isClass(TestCaseStatus.class)).typeFor(new String[]{AUTOMATABLE}).isClass(TestCaseAutomatable.class)).typeFor(new String[]{AUTOMATION_REQUEST_REQUEST_STATUS}).isClass(AutomationRequestStatus.class)).build();
    }

    private Session getSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    private long countUsingTestCases(HibernateQuery<TestCase> baseQuery) {
        HibernateQuery countUsingTestCases = (HibernateQuery)baseQuery.clone();
        return countUsingTestCases.fetchCount();
    }
}

