/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.exception;

import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.exception.BugzillaXmlrpcIssueNotFoundException;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.exception.BugzillaXmlrpcLoginFailException;

@Component
public class BugzillaExceptionHandler {
    @Inject
    @Named(value="bugzillaConnectorMessageSource")
    private MessageSource messageSource;

    private Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public BugTrackerRemoteException authenticationException(BugzillaXmlrpcLoginFailException e) {
        String expression = e.getMessage();
        String translation = this.messageSource.getMessage("exception.squash.accessdenied", new Object[]{expression}, this.getLocale());
        return new BugTrackerRemoteException(translation, e.getCause());
    }

    public BugTrackerRemoteException issueNotFoundException(BugzillaXmlrpcIssueNotFoundException e) {
        String expression = e.getMessage();
        String translation = this.messageSource.getMessage("exception.squash.notfound.issue", new Object[]{expression}, this.getLocale());
        return new BugTrackerRemoteException(translation, e.getCause());
    }

    public BugTrackerRemoteException genericError(Exception e) {
        String translation = this.messageSource.getMessage("exception.squash.unknownexception", null, this.getLocale());
        return new BugTrackerRemoteException(String.valueOf(translation) + e.getMessage(), e.getCause());
    }

    public BugTrackerRemoteException projectNotFound(Exception e) {
        String expression = e.getMessage();
        String translation = this.messageSource.getMessage("exception.squash.notfound.project", new Object[]{expression}, this.getLocale());
        return new BugTrackerRemoteException(translation, e.getCause());
    }

    public BugTrackerRemoteException userNotAssignable(Exception exception) {
        String expression = exception.getMessage();
        String translation = this.messageSource.getMessage("exception.squash.notassignable.user", new Object[]{expression}, this.getLocale());
        return new BugTrackerRemoteException(translation, exception.getCause());
    }

    private static interface SquashMessageKeys {
        public static final String UNKNOWN_EXCEPTION = "exception.squash.unknownexception";
        public static final String WRONG_CREDENTIALS = "exception.squash.accessdenied";
        public static final String OPERATION_DENIED = "exception.squash.operationdenied";
        public static final String ISSUE_NOT_FOUND = "exception.squash.notfound.issue";
        public static final String PROJECT_NOT_FOUND = "exception.squash.notfound.project";
        public static final String NUMBER_CONVERSION = "exception.squash.number.conversion";
        public static final String USER_NOT_ASSIGNABLE = "exception.squash.notassignable.user";
    }
}

