/*
 * Decompiled with CFR 0.152.
 */
package bugzilla.org.apache.xmlrpc.common;

import bugzilla.org.apache.xmlrpc.common.TypeConverter;
import bugzilla.org.apache.xmlrpc.common.TypeConverterFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class TypeConverterFactoryImpl
implements TypeConverterFactory {
    private static final TypeConverter voidTypeConverter = new IdentityTypeConverter(Void.TYPE);
    private static final TypeConverter mapTypeConverter = new IdentityTypeConverter(class$java$util$Map == null ? (class$java$util$Map = TypeConverterFactoryImpl.class$("java.util.Map")) : class$java$util$Map);
    private static final TypeConverter objectArrayTypeConverter = new IdentityTypeConverter(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = TypeConverterFactoryImpl.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
    private static final TypeConverter byteArrayTypeConverter = new IdentityTypeConverter(array$B == null ? (array$B = TypeConverterFactoryImpl.class$("[B")) : array$B);
    private static final TypeConverter stringTypeConverter = new IdentityTypeConverter(class$java$lang$String == null ? (class$java$lang$String = TypeConverterFactoryImpl.class$("java.lang.String")) : class$java$lang$String);
    private static final TypeConverter booleanTypeConverter = new IdentityTypeConverter(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeConverterFactoryImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    private static final TypeConverter characterTypeConverter = new IdentityTypeConverter(class$java$lang$Character == null ? (class$java$lang$Character = TypeConverterFactoryImpl.class$("java.lang.Character")) : class$java$lang$Character);
    private static final TypeConverter byteTypeConverter = new IdentityTypeConverter(class$java$lang$Byte == null ? (class$java$lang$Byte = TypeConverterFactoryImpl.class$("java.lang.Byte")) : class$java$lang$Byte);
    private static final TypeConverter shortTypeConverter = new IdentityTypeConverter(class$java$lang$Short == null ? (class$java$lang$Short = TypeConverterFactoryImpl.class$("java.lang.Short")) : class$java$lang$Short);
    private static final TypeConverter integerTypeConverter = new IdentityTypeConverter(class$java$lang$Integer == null ? (class$java$lang$Integer = TypeConverterFactoryImpl.class$("java.lang.Integer")) : class$java$lang$Integer);
    private static final TypeConverter longTypeConverter = new IdentityTypeConverter(class$java$lang$Long == null ? (class$java$lang$Long = TypeConverterFactoryImpl.class$("java.lang.Long")) : class$java$lang$Long);
    private static final TypeConverter bigDecimalTypeConverter = new IdentityTypeConverter(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeConverterFactoryImpl.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
    private static final TypeConverter bigIntegerTypeConverter = new IdentityTypeConverter(class$java$math$BigInteger == null ? (class$java$math$BigInteger = TypeConverterFactoryImpl.class$("java.math.BigInteger")) : class$java$math$BigInteger);
    private static final TypeConverter floatTypeConverter = new IdentityTypeConverter(class$java$lang$Float == null ? (class$java$lang$Float = TypeConverterFactoryImpl.class$("java.lang.Float")) : class$java$lang$Float);
    private static final TypeConverter doubleTypeConverter = new IdentityTypeConverter(class$java$lang$Double == null ? (class$java$lang$Double = TypeConverterFactoryImpl.class$("java.lang.Double")) : class$java$lang$Double);
    private static final TypeConverter dateTypeConverter = new IdentityTypeConverter(class$java$util$Date == null ? (class$java$util$Date = TypeConverterFactoryImpl.class$("java.util.Date")) : class$java$util$Date);
    private static final TypeConverter calendarTypeConverter = new IdentityTypeConverter(class$java$util$Calendar == null ? (class$java$util$Calendar = TypeConverterFactoryImpl.class$("java.util.Calendar")) : class$java$util$Calendar);
    private static final TypeConverter domTypeConverter = new IdentityTypeConverter(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = TypeConverterFactoryImpl.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document);
    private static final TypeConverter primitiveBooleanTypeConverter = new PrimitiveTypeConverter(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeConverterFactoryImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    private static final TypeConverter primitiveCharTypeConverter = new PrimitiveTypeConverter(class$java$lang$Character == null ? (class$java$lang$Character = TypeConverterFactoryImpl.class$("java.lang.Character")) : class$java$lang$Character);
    private static final TypeConverter primitiveByteTypeConverter = new PrimitiveTypeConverter(class$java$lang$Byte == null ? (class$java$lang$Byte = TypeConverterFactoryImpl.class$("java.lang.Byte")) : class$java$lang$Byte);
    private static final TypeConverter primitiveShortTypeConverter = new PrimitiveTypeConverter(class$java$lang$Short == null ? (class$java$lang$Short = TypeConverterFactoryImpl.class$("java.lang.Short")) : class$java$lang$Short);
    private static final TypeConverter primitiveIntTypeConverter = new PrimitiveTypeConverter(class$java$lang$Integer == null ? (class$java$lang$Integer = TypeConverterFactoryImpl.class$("java.lang.Integer")) : class$java$lang$Integer);
    private static final TypeConverter primitiveLongTypeConverter = new PrimitiveTypeConverter(class$java$lang$Long == null ? (class$java$lang$Long = TypeConverterFactoryImpl.class$("java.lang.Long")) : class$java$lang$Long);
    private static final TypeConverter primitiveFloatTypeConverter = new PrimitiveTypeConverter(class$java$lang$Float == null ? (class$java$lang$Float = TypeConverterFactoryImpl.class$("java.lang.Float")) : class$java$lang$Float);
    private static final TypeConverter primitiveDoubleTypeConverter = new PrimitiveTypeConverter(class$java$lang$Double == null ? (class$java$lang$Double = TypeConverterFactoryImpl.class$("java.lang.Double")) : class$java$lang$Double);
    private static final TypeConverter propertiesTypeConverter = new TypeConverter(){

        public boolean isConvertable(Object pObject) {
            return pObject == null || pObject instanceof Map;
        }

        public Object convert(Object pObject) {
            if (pObject == null) {
                return null;
            }
            Properties props = new Properties();
            props.putAll((Map<?, ?>)((Map)pObject));
            return props;
        }

        public Object backConvert(Object pObject) {
            return pObject;
        }
    };
    private static final TypeConverter hashTableTypeConverter = new TypeConverter(){

        public boolean isConvertable(Object pObject) {
            return pObject == null || pObject instanceof Map;
        }

        public Object convert(Object pObject) {
            if (pObject == null) {
                return null;
            }
            return new Hashtable((Map)pObject);
        }

        public Object backConvert(Object pObject) {
            return pObject;
        }
    };
    private static final TypeConverter listTypeConverter = new ListTypeConverter(class$java$util$List == null ? (class$java$util$List = TypeConverterFactoryImpl.class$("java.util.List")) : class$java$util$List){

        protected List newList(int pSize) {
            return new ArrayList(pSize);
        }
    };
    private static final TypeConverter vectorTypeConverter = new ListTypeConverter(class$java$util$Vector == null ? (class$java$util$Vector = TypeConverterFactoryImpl.class$("java.util.Vector")) : class$java$util$Vector){

        protected List newList(int pSize) {
            return new Vector(pSize);
        }
    };
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$org$w3c$dom$Document;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$io$Serializable;

    public TypeConverter getTypeConverter(Class pClass) {
        if (Void.TYPE.equals(pClass)) {
            return voidTypeConverter;
        }
        if (pClass.isAssignableFrom(Boolean.TYPE)) {
            return primitiveBooleanTypeConverter;
        }
        if (pClass.isAssignableFrom(Character.TYPE)) {
            return primitiveCharTypeConverter;
        }
        if (pClass.isAssignableFrom(Byte.TYPE)) {
            return primitiveByteTypeConverter;
        }
        if (pClass.isAssignableFrom(Short.TYPE)) {
            return primitiveShortTypeConverter;
        }
        if (pClass.isAssignableFrom(Integer.TYPE)) {
            return primitiveIntTypeConverter;
        }
        if (pClass.isAssignableFrom(Long.TYPE)) {
            return primitiveLongTypeConverter;
        }
        if (pClass.isAssignableFrom(Float.TYPE)) {
            return primitiveFloatTypeConverter;
        }
        if (pClass.isAssignableFrom(Double.TYPE)) {
            return primitiveDoubleTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$lang$String == null ? (class$java$lang$String = TypeConverterFactoryImpl.class$("java.lang.String")) : class$java$lang$String)) {
            return stringTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeConverterFactoryImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return booleanTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$lang$Character == null ? (class$java$lang$Character = TypeConverterFactoryImpl.class$("java.lang.Character")) : class$java$lang$Character)) {
            return characterTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$lang$Byte == null ? (class$java$lang$Byte = TypeConverterFactoryImpl.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return byteTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$lang$Short == null ? (class$java$lang$Short = TypeConverterFactoryImpl.class$("java.lang.Short")) : class$java$lang$Short)) {
            return shortTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$lang$Integer == null ? (class$java$lang$Integer = TypeConverterFactoryImpl.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return integerTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$lang$Long == null ? (class$java$lang$Long = TypeConverterFactoryImpl.class$("java.lang.Long")) : class$java$lang$Long)) {
            return longTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeConverterFactoryImpl.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return bigDecimalTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$math$BigInteger == null ? (class$java$math$BigInteger = TypeConverterFactoryImpl.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return bigIntegerTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$lang$Float == null ? (class$java$lang$Float = TypeConverterFactoryImpl.class$("java.lang.Float")) : class$java$lang$Float)) {
            return floatTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$lang$Double == null ? (class$java$lang$Double = TypeConverterFactoryImpl.class$("java.lang.Double")) : class$java$lang$Double)) {
            return doubleTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = TypeConverterFactoryImpl.class$("java.util.Date")) : class$java$util$Date)) {
            return dateTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$util$Calendar == null ? (class$java$util$Calendar = TypeConverterFactoryImpl.class$("java.util.Calendar")) : class$java$util$Calendar)) {
            return calendarTypeConverter;
        }
        if (pClass.isAssignableFrom(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = TypeConverterFactoryImpl.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object)) {
            return objectArrayTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$util$List == null ? (class$java$util$List = TypeConverterFactoryImpl.class$("java.util.List")) : class$java$util$List)) {
            return listTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$util$Vector == null ? (class$java$util$Vector = TypeConverterFactoryImpl.class$("java.util.Vector")) : class$java$util$Vector)) {
            return vectorTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$util$Map == null ? (class$java$util$Map = TypeConverterFactoryImpl.class$("java.util.Map")) : class$java$util$Map)) {
            return mapTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$util$Hashtable == null ? (class$java$util$Hashtable = TypeConverterFactoryImpl.class$("java.util.Hashtable")) : class$java$util$Hashtable)) {
            return hashTableTypeConverter;
        }
        if (pClass.isAssignableFrom(class$java$util$Properties == null ? (class$java$util$Properties = TypeConverterFactoryImpl.class$("java.util.Properties")) : class$java$util$Properties)) {
            return propertiesTypeConverter;
        }
        if (pClass.isAssignableFrom(array$B == null ? (array$B = TypeConverterFactoryImpl.class$("[B")) : array$B)) {
            return byteArrayTypeConverter;
        }
        if (pClass.isAssignableFrom(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = TypeConverterFactoryImpl.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document)) {
            return domTypeConverter;
        }
        if ((class$java$io$Serializable == null ? (class$java$io$Serializable = TypeConverterFactoryImpl.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(pClass)) {
            return new CastCheckingTypeConverter(pClass);
        }
        throw new IllegalStateException("Invalid parameter or result type: " + pClass.getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CastCheckingTypeConverter
    implements TypeConverter {
        private final Class clazz;

        CastCheckingTypeConverter(Class pClass) {
            this.clazz = pClass;
        }

        public boolean isConvertable(Object pObject) {
            return pObject == null || this.clazz.isAssignableFrom(pObject.getClass());
        }

        public Object convert(Object pObject) {
            return pObject;
        }

        public Object backConvert(Object pObject) {
            return pObject;
        }
    }

    private static class PrimitiveTypeConverter
    implements TypeConverter {
        private final Class clazz;

        PrimitiveTypeConverter(Class pClass) {
            this.clazz = pClass;
        }

        public boolean isConvertable(Object pObject) {
            return pObject != null && pObject.getClass().isAssignableFrom(this.clazz);
        }

        public Object convert(Object pObject) {
            return pObject;
        }

        public Object backConvert(Object pObject) {
            return pObject;
        }
    }

    private static abstract class ListTypeConverter
    implements TypeConverter {
        private final Class clazz;

        ListTypeConverter(Class pClass) {
            this.clazz = pClass;
        }

        protected abstract List newList(int var1);

        public boolean isConvertable(Object pObject) {
            return pObject == null || pObject instanceof Object[] || pObject instanceof Collection;
        }

        public Object convert(Object pObject) {
            if (pObject == null) {
                return null;
            }
            if (this.clazz.isAssignableFrom(pObject.getClass())) {
                return pObject;
            }
            if (pObject instanceof Object[]) {
                Object[] objects = (Object[])pObject;
                List result = this.newList(objects.length);
                for (int i = 0; i < objects.length; ++i) {
                    result.add(objects[i]);
                }
                return result;
            }
            Collection collection = (Collection)pObject;
            List result = this.newList(collection.size());
            result.addAll(collection);
            return result;
        }

        public Object backConvert(Object pObject) {
            return ((List)pObject).toArray();
        }
    }

    private static class IdentityTypeConverter
    implements TypeConverter {
        private final Class clazz;

        IdentityTypeConverter(Class pClass) {
            this.clazz = pClass;
        }

        public boolean isConvertable(Object pObject) {
            return pObject == null || this.clazz.isAssignableFrom(pObject.getClass());
        }

        public Object convert(Object pObject) {
            return pObject;
        }

        public Object backConvert(Object pObject) {
            return pObject;
        }
    }
}

