/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.conversion.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HTMLTextBuilder {
    public static final String TABULATION = "&nbsp;&nbsp;&nbsp;";
    public static final String LINE_BREAK = "<br>";
    private final List<Element> elements = new ArrayList<Element>();

    public HTMLTextBuilder append(Element element) {
        this.elements.add(element);
        return this;
    }

    public HTMLTextBuilder append(String text) {
        this.elements.add(new TextElement(text));
        return this;
    }

    public HTMLTextBuilder appendTitle1(String text) {
        return this.appendTitle(text, 22);
    }

    public HTMLTextBuilder appendTitle2(String text) {
        return this.appendTitle(text, 18);
    }

    public HTMLTextBuilder appendTitle3(String text) {
        return this.appendTitle(text, 14);
    }

    public HTMLTextBuilder appendTitle(String text, int px) {
        HashMap<String, String> style = new HashMap<String, String>();
        style.put("font-size", String.format("%spx", px));
        SpanElement span = new SpanElement(style);
        span.appendText(text);
        this.append(new PElement().append(new StrongElement().append(span)));
        return this;
    }

    public String build() {
        StringBuilder htmlStringBuilder = new StringBuilder();
        this.elements.forEach(element -> htmlStringBuilder.append(element.build()));
        return htmlStringBuilder.toString();
    }

    public PElement createParagraph() {
        return new PElement();
    }

    public class TextElement
    extends Element {
        public final String text;

        TextElement(String text) {
            this.text = text;
        }

        @Override
        String build() {
            return this.text;
        }
    }

    public class SpanElement
    extends ContainerElement {
        SpanElement(Map<String, String> style) {
            super("span", style);
        }
    }

    public class ContainerElement
    extends TagElement {
        private final List<Element> elements;

        public ContainerElement(String tag) {
            this(tag, Collections.emptyMap());
        }

        public ContainerElement(String tag, Map<String, String> style) {
            super(tag, style);
            this.elements = new ArrayList<Element>();
        }

        public ContainerElement append(Element element) {
            this.elements.add(element);
            return this;
        }

        public ContainerElement appendText(String text) {
            this.elements.add(new TextElement(text));
            return this;
        }

        public ContainerElement appendCode(String text) {
            HashMap<String, String> style = new HashMap<String, String>();
            style.put("font-family", "Courier New,Courier,monospace");
            String code = Arrays.stream(text.split("\n")).map(s -> s.replace("\t", HTMLTextBuilder.TABULATION)).collect(Collectors.joining(HTMLTextBuilder.LINE_BREAK));
            SpanElement span = new SpanElement(style);
            span.appendText(code);
            return this.append(span);
        }

        @Override
        String build() {
            StringBuilder paragraph = new StringBuilder();
            paragraph.append(this.getOpenTag());
            this.elements.forEach(element -> paragraph.append(element.build()));
            paragraph.append(this.getCloseTag());
            return paragraph.toString();
        }
    }

    public class PElement
    extends ContainerElement {
        PElement() {
            super("p");
        }
    }

    public class StrongElement
    extends ContainerElement {
        StrongElement() {
            super("strong");
        }
    }

    abstract class Element {
        Element() {
        }

        abstract String build();
    }

    abstract class TagElement
    extends Element {
        private final String tag;
        private final Map<String, String> style;

        public TagElement(String tag) {
            this(tag, Collections.emptyMap());
        }

        public TagElement(String tag, Map<String, String> style) {
            this.tag = tag;
            this.style = style;
        }

        @Override
        abstract String build();

        protected String getOpenTag() {
            String style = this.buildStyle();
            if (style.isEmpty()) {
                return String.format("<%s>", this.tag);
            }
            return String.format("<%s %s>", this.tag, style);
        }

        protected String getCloseTag() {
            return String.format("</%s>", this.tag);
        }

        protected String buildStyle() {
            if (this.style.isEmpty()) {
                return "";
            }
            List pairs = this.style.entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).collect(Collectors.toList());
            String styleContent = String.join((CharSequence)"; ", pairs);
            return String.format("style=\"%s\"", styleContent);
        }
    }
}

