/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.testcases.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.repository.SqlQueryRunner;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.plugin.report.books.testcases.beans.ActionWordFragmentValueDto;
import org.squashtest.tm.plugin.report.books.testcases.beans.Cuf;
import org.squashtest.tm.plugin.report.books.testcases.beans.Data;
import org.squashtest.tm.plugin.report.books.testcases.beans.Dataset;
import org.squashtest.tm.plugin.report.books.testcases.beans.DatasetParamValue;
import org.squashtest.tm.plugin.report.books.testcases.beans.LinkedRequirements;
import org.squashtest.tm.plugin.report.books.testcases.beans.Node;
import org.squashtest.tm.plugin.report.books.testcases.beans.Parameter;
import org.squashtest.tm.plugin.report.books.testcases.beans.PrintableCuf;
import org.squashtest.tm.plugin.report.books.testcases.beans.Project;
import org.squashtest.tm.plugin.report.books.testcases.beans.TestCase;
import org.squashtest.tm.plugin.report.books.testcases.beans.TestCaseSteps;
import org.squashtest.tm.plugin.report.books.testcases.foundation.CriteriaEntry;
import org.squashtest.tm.plugin.report.books.testcases.foundation.CufType;
import org.squashtest.tm.plugin.report.books.testcases.foundation.EntityType;
import org.squashtest.tm.plugin.report.books.testcases.foundation.ReportOptions;
import org.squashtest.tm.plugin.report.books.testcases.query.TestCasesTreeFormatter;
import org.squashtest.tm.plugin.report.books.testcases.query.TestCasesTreeQueryFinder;

public class TestCasesTreeQuery
implements ReportQuery,
InitializingBean {
    public static final Logger LOGGER = LoggerFactory.getLogger(TestCasesTreeQuery.class);
    private static final String DATA = "data";
    private static final String DEFAULT_SORT_ORDER = "ALPHABETICAL";
    private static final String DEFAULT_TEMPLATE_VALUE = "defaultTemplate";
    private static final String FILENAME = "fileName";
    private static final String HTML = "html";
    private static final String MILESTONE_ID = "milestoneId";
    private static final String MILESTONE_LABEL = "milestoneLabel";
    private static final String MILESTONE_PICKER = "MILESTONE_PICKER";
    private static final String SQL_FIND_MILESTONE_LABEL = "select label from MILESTONE where milestone_id = :milestoneId";
    private static final String TAG_PICKER = "TAG_PICKER";
    private static final String TEMPLATE_FILE_NAME = "templateFileName";
    private static final String TEST_CASE_SELECTION_MODE = "testcasesSelectionMode";
    private static final String TEST_CASE_SORT_ORDER = "testCaseSortOrder";
    private static final String TREE_PICKER = "TREE_PICKER";
    private SqlQueryRunner runner;
    private TestCasesTreeFormatter formatter = new TestCasesTreeFormatter();
    private TestCasesTreeQueryFinder queryFinder = new TestCasesTreeQueryFinder();
    private CurrentUserHelper currentUserHelper;

    public void setFormatter(TestCasesTreeFormatter formatter) {
        this.formatter = formatter;
    }

    public void afterPropertiesSet() throws Exception {
        this.queryFinder.setRunner(this.runner);
    }

    public void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    public void setCurrentUserHelper(CurrentUserHelper currentUserHelper) {
        this.currentUserHelper = currentUserHelper;
    }

    /*
     * WARNING - void declaration
     */
    public void executeQuery(Map<String, Criteria> crit, Map<String, Object> res) {
        ArrayList<String> html = new ArrayList<String>();
        HashMap<String, Boolean> optionsMap = new HashMap<String, Boolean>();
        optionsMap.put(ReportOptions.PRINT_STEPS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_LINKED_REQUIREMENTS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_CALL_STEPS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_PARAMETERS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_STEP_CUFS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_STEP_ATTACHMENTS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_STEP_LINKED_REQUIREMENTS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_FOLDER.getValue(), false);
        Criteria options = crit.get(CriteriaEntry.REPORT_OPTIONS.getValue());
        Collection selectedOptions = (Collection)options.getValue();
        for (String option : selectedOptions) {
            optionsMap.put(option, true);
        }
        String testCaseSortOrder = Objects.nonNull(crit.get(TEST_CASE_SORT_ORDER)) ? (String)crit.get(TEST_CASE_SORT_ORDER).getValue() : DEFAULT_SORT_ORDER;
        String templateFileName = this.retrieveTemplateFileName(crit.get(TEMPLATE_FILE_NAME));
        Collection<Object[]> rawNodesData = this.getNodeBean(crit, testCaseSortOrder);
        List<Node> nodesBeans = this.formatter.toNodesBean(rawNodesData);
        Collection<Long> tcIds = this.getTcIds(crit);
        if (!tcIds.isEmpty()) {
            Collection<Object[]> rawTestCaseData = this.queryFinder.getTestCasesData(tcIds, testCaseSortOrder);
            Collection<Object[]> rawConfigurationData = this.queryFinder.getMilestoneConfiguration();
            boolean printMilestones = this.formatter.rawMilestoneConfigToBoolean(rawConfigurationData);
            boolean printLinkedRequirement = (Boolean)optionsMap.get(ReportOptions.PRINT_LINKED_REQUIREMENTS.getValue());
            boolean printParameters = (Boolean)optionsMap.get(ReportOptions.PRINT_PARAMETERS.getValue());
            boolean printStepCufs = (Boolean)optionsMap.get(ReportOptions.PRINT_STEP_CUFS.getValue());
            boolean printStepLinkedRequirement = (Boolean)optionsMap.get(ReportOptions.PRINT_STEP_LINKED_REQUIREMENTS.getValue());
            boolean printStepAttachment = (Boolean)optionsMap.get(ReportOptions.PRINT_STEP_ATTACHMENTS.getValue());
            boolean printFolder = (Boolean)optionsMap.get(ReportOptions.PRINT_FOLDER.getValue());
            boolean printSteps = (Boolean)optionsMap.get(ReportOptions.PRINT_STEPS.getValue());
            ArrayList<LinkedRequirements> linkedRequirementsBeans = new ArrayList();
            if (printLinkedRequirement) {
                Collection<Object[]> rawLinkedReqData = this.queryFinder.getLinkedReqData(tcIds);
                linkedRequirementsBeans = this.formatter.toLinkedRequirementBean(rawLinkedReqData);
            }
            ArrayList<Parameter> parameters = new ArrayList();
            ArrayList<Dataset> datasets = new ArrayList();
            ArrayList<DatasetParamValue> datasetParamValuesData = new ArrayList();
            if (printParameters) {
                Collection<Object[]> rawParametersData = this.queryFinder.getParametersData(tcIds);
                parameters = this.formatter.toParameter(rawParametersData);
                Collection<Object[]> rawDataSetData = this.queryFinder.getDataSetData(tcIds);
                datasets = this.formatter.toDataSet(rawDataSetData);
                Collection<Object[]> rawDataSetParamValuesData = this.queryFinder.getDataSetParamValueData(tcIds);
                datasetParamValuesData = this.formatter.toDataSetParamValue(rawDataSetParamValuesData);
            }
            Collection<Object> testCaseStepsBeans = new ArrayList();
            HashMap<String, Object> stepCufMap = new HashMap<String, Object>();
            ArrayList<LinkedRequirements> linkedRequirementsBySteps = new ArrayList();
            ArrayList<PrintableCuf> printableStepCufs = new ArrayList();
            if (((Boolean)optionsMap.get(ReportOptions.PRINT_STEPS.getValue())).booleanValue()) {
                void var35_41;
                Collection<Object[]> rawTestCaseStepsData = this.queryFinder.getTestCaseStepsData(tcIds);
                boolean printAttachments = (Boolean)optionsMap.get(ReportOptions.PRINT_STEP_ATTACHMENTS.getValue());
                Collection<Object[]> rawBddActionFragments = this.queryFinder.getBddActionFragmentsData(tcIds);
                Collection<ActionWordFragmentValueDto> actionWordFragmentValues = this.formatter.toActionWordFragmentValues(rawBddActionFragments);
                testCaseStepsBeans = this.formatter.toTestCaseSteps(rawTestCaseStepsData, actionWordFragmentValues, printAttachments, printStepLinkedRequirement, printStepCufs);
                if (((Boolean)optionsMap.get(ReportOptions.PRINT_CALL_STEPS.getValue())).booleanValue()) {
                    ArrayList<TestCaseSteps> caseStepsBeans = new ArrayList<TestCaseSteps>();
                    this.addCalledSteps(testCaseStepsBeans, caseStepsBeans, printStepAttachment, printStepLinkedRequirement, printStepCufs);
                    testCaseStepsBeans = caseStepsBeans;
                }
                ArrayList<Long> stepIds = new ArrayList<Long>();
                for (TestCaseSteps testCaseSteps : testCaseStepsBeans) {
                    stepIds.add(testCaseSteps.getId());
                }
                ArrayList arrayList = new ArrayList();
                Collection<Cuf> stepNumCuf = new ArrayList<Cuf>();
                Collection<Cuf> stepTagCuf = new ArrayList<Cuf>();
                Collection<Cuf> stepRtfCuf = new ArrayList<Cuf>();
                if (!stepIds.isEmpty()) {
                    if (((Boolean)optionsMap.get(ReportOptions.PRINT_STEP_CUFS.getValue())).booleanValue()) {
                        Collection<Object[]> rawStepCuf = this.queryFinder.getCufData(EntityType.TEST_STEP.name(), stepIds);
                        Collection<Object[]> rawStepNumCuf = this.queryFinder.getNumCufData(EntityType.TEST_STEP.name(), stepIds);
                        Collection<Object[]> rawStepTagCuf = this.queryFinder.getTagCufData(EntityType.TEST_STEP.name(), stepIds);
                        Collection<Object[]> rawStepRtfCuf = this.queryFinder.getRtfCufData(EntityType.TEST_STEP.name(), stepIds);
                        Collection<Cuf> collection = this.formatter.toCufBean(rawStepCuf);
                        stepNumCuf = this.formatter.toCufBean(rawStepNumCuf);
                        stepTagCuf = this.formatter.toTagCufBean(rawStepTagCuf);
                        stepRtfCuf = this.formatter.toCufBean(rawStepRtfCuf);
                    }
                    if (((Boolean)optionsMap.get(ReportOptions.PRINT_STEP_LINKED_REQUIREMENTS.getValue())).booleanValue()) {
                        Collection<Object[]> rawLinkedReqTestSteps = this.queryFinder.getLinkedReqStepsData(stepIds);
                        linkedRequirementsBySteps = this.formatter.toLinkedRequirementByStepsBean(rawLinkedReqTestSteps);
                    }
                }
                stepCufMap.put(CufType.CUFS.getValue(), var35_41);
                stepCufMap.put(CufType.NUM_CUFS.getValue(), stepNumCuf);
                stepCufMap.put(CufType.TAG_CUFS.getValue(), stepTagCuf);
                stepCufMap.put(CufType.RTF_CUFS.getValue(), stepRtfCuf);
                printableStepCufs = this.formatter.toPrintableCufCollection((Collection<Cuf>)var35_41, stepNumCuf, stepTagCuf, stepRtfCuf, html);
            }
            Collection<TestCase> testCaseBeans = this.formatter.toTestCaseBean(rawTestCaseData, printLinkedRequirement, printParameters, printFolder, printSteps, printMilestones);
            List<Long> folderIds = this.getFolderIds(testCaseBeans);
            HashMap<String, Collection<Cuf>> testCaseCufMap = new HashMap<String, Collection<Cuf>>();
            Collection<Object[]> rawTestCaseCuf = this.queryFinder.getCufData(EntityType.TEST_CASE.name(), tcIds);
            rawTestCaseCuf.addAll(this.queryFinder.getCufData(EntityType.TESTCASE_FOLDER.name(), folderIds));
            Collection<Cuf> testCaseCuf = this.formatter.toCufBean(rawTestCaseCuf);
            testCaseCufMap.put(CufType.CUFS.getValue(), testCaseCuf);
            Collection<Object[]> collection = this.queryFinder.getNumCufData(EntityType.TEST_CASE.name(), tcIds);
            collection.addAll(this.queryFinder.getNumCufData(EntityType.TESTCASE_FOLDER.name(), folderIds));
            Collection<Cuf> testCaseNumCuf = this.formatter.toCufBean(collection);
            testCaseCufMap.put(CufType.NUM_CUFS.getValue(), testCaseNumCuf);
            Collection<Object[]> rawTestCaseTagCuf = this.queryFinder.getTagCufData(EntityType.TEST_CASE.name(), tcIds);
            rawTestCaseTagCuf.addAll(this.queryFinder.getTagCufData(EntityType.TESTCASE_FOLDER.name(), folderIds));
            Collection<Cuf> testCaseTagCuf = this.formatter.toTagCufBean(rawTestCaseTagCuf);
            testCaseCufMap.put(CufType.TAG_CUFS.getValue(), testCaseTagCuf);
            Collection<Object[]> rawTestCaseRtfCuf = this.queryFinder.getRtfCufData(EntityType.TEST_CASE.name(), tcIds);
            rawTestCaseRtfCuf.addAll(this.queryFinder.getRtfCufData(EntityType.TESTCASE_FOLDER.name(), folderIds));
            Collection<Cuf> testCaseRtfCuf = this.formatter.toCufBean(rawTestCaseRtfCuf);
            testCaseCufMap.put(CufType.RTF_CUFS.getValue(), testCaseRtfCuf);
            Collection<PrintableCuf> testCasePrintCufs = this.formatter.toPrintableCufCollection(testCaseCuf, testCaseNumCuf, testCaseTagCuf, testCaseRtfCuf, html);
            this.formatter.bindAll(testCaseStepsBeans, linkedRequirementsBeans, testCaseBeans, linkedRequirementsBySteps, parameters, datasets, datasetParamValuesData, nodesBeans, printableStepCufs, testCasePrintCufs);
        }
        String milestoneLabel = null;
        if (this.isMilestonePicker(crit)) {
            List milestoneIds = (List)crit.get(CriteriaEntry.MILESTONES.getValue()).getValue();
            HashMap params = new HashMap();
            params.put(MILESTONE_ID, milestoneIds.get(0));
            milestoneLabel = (String)this.runner.executeUniqueSelect(SQL_FIND_MILESTONE_LABEL, params);
            res.put(MILESTONE_LABEL, milestoneLabel);
        }
        this.processRichText(nodesBeans, html);
        this.processChain(nodesBeans);
        Data data = new Data(milestoneLabel, testCaseSortOrder, templateFileName);
        data.setProjects(this.populateProjectFromNode(nodesBeans));
        res.put(FILENAME, data.getFileTitleTestCasesReport());
        res.put(DATA, data);
        res.put(HTML, html);
    }

    private String retrieveTemplateFileName(Criteria templateCriteria) {
        if (Objects.nonNull(templateCriteria)) {
            try {
                return (String)templateCriteria.getValue();
            }
            catch (ClassCastException cce) {
                LOGGER.trace("Custom template file does not exist anymore.", (Throwable)cce);
            }
        }
        return DEFAULT_TEMPLATE_VALUE;
    }

    private List<Long> getFolderIds(Collection<TestCase> testCaseBeans) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        for (TestCase testCaseBean : testCaseBeans) {
            if (!testCaseBean.isFolder()) continue;
            folderIds.add(testCaseBean.getId());
        }
        return folderIds;
    }

    private Collection<Long> getTcIds(Map<String, Criteria> criteriaMap) {
        Criteria selectionMode = criteriaMap.get(TEST_CASE_SELECTION_MODE);
        Collection<Object> testCaseIdList = Collections.emptyList();
        List readableProjectIds = this.currentUserHelper.findReadableProjectIds();
        if (TREE_PICKER.equals(selectionMode.getValue())) {
            Criteria idsCrit = criteriaMap.get(CriteriaEntry.TEST_CASE_IDS.getValue());
            Collection testCaseIds = this.addNodesIds(idsCrit);
            testCaseIdList = this.queryFinder.findIdsBySelection(testCaseIds, readableProjectIds);
        } else if (MILESTONE_PICKER.equals(selectionMode.getValue())) {
            Collection milestones = (Collection)criteriaMap.get(CriteriaEntry.MILESTONES.getValue()).getValue();
            testCaseIdList = this.queryFinder.findIdsByMilestone(milestones, readableProjectIds);
        } else if (TAG_PICKER.equals(selectionMode.getValue())) {
            Collection tags = (Collection)criteriaMap.get(CriteriaEntry.TAGS.getValue()).getValue();
            testCaseIdList = this.queryFinder.findIdsByTags(tags, readableProjectIds);
        } else {
            Criteria idsCrit = criteriaMap.get(CriteriaEntry.PROJECT_IDS.getValue());
            if (!idsCrit.getValue().toString().trim().isEmpty()) {
                List<Long> projectIds = ((Collection)idsCrit.getValue()).stream().map(Long::valueOf).toList();
                readableProjectIds.retainAll(projectIds);
                testCaseIdList = this.queryFinder.findIdsByProject(readableProjectIds);
            }
        }
        return testCaseIdList;
    }

    private Collection<Object[]> getNodeBean(Map<String, Criteria> criteriaMap, String testCaseSortOrder) {
        Criteria selectionMode = criteriaMap.get(CriteriaEntry.TEST_CASES_SELECTION_MODE.getValue());
        Collection<Object> result = new ArrayList();
        List readableProjectIds = this.currentUserHelper.findReadableProjectIds();
        if (TREE_PICKER.equals(selectionMode.getValue())) {
            Criteria idsCrit = criteriaMap.get(CriteriaEntry.TEST_CASE_IDS.getValue());
            Collection testCaseIds = this.addNodesIds(idsCrit);
            result = this.queryFinder.getNodesByTestCasesIds(testCaseIds, readableProjectIds, testCaseSortOrder);
        } else if (MILESTONE_PICKER.equals(selectionMode.getValue())) {
            Collection milestoneIds = (Collection)criteriaMap.get(CriteriaEntry.MILESTONES.getValue()).getValue();
            result = this.queryFinder.getNodesByMilestones(milestoneIds, readableProjectIds, testCaseSortOrder);
        } else if (TAG_PICKER.equals(selectionMode.getValue())) {
            Collection tags = (Collection)criteriaMap.get(CriteriaEntry.TAGS.getValue()).getValue();
            result = this.queryFinder.getNodesTags(tags, readableProjectIds, testCaseSortOrder);
        } else {
            Criteria idsCrit = criteriaMap.get(CriteriaEntry.PROJECT_IDS.getValue());
            if (!idsCrit.getValue().toString().trim().isEmpty()) {
                List<Long> projectIds = ((Collection)idsCrit.getValue()).stream().map(Long::valueOf).toList();
                readableProjectIds.retainAll(projectIds);
                result = this.queryFinder.getNodesByProjectIds(readableProjectIds, testCaseSortOrder);
            }
        }
        return result;
    }

    public void setIdsByProjectQuery(Resource idsByProjectQuery) {
        String query = this.loadQuery(idsByProjectQuery);
        this.queryFinder.setIdsByProjectQuery(query);
    }

    public void setIdsByTagQuery(Resource idsByTagQuery) {
        String query = this.loadQuery(idsByTagQuery);
        this.queryFinder.setIdsByTagQuery(query);
    }

    public void setIdsBySelectionQuery(Resource idsBySelectionQuery) {
        String query = this.loadQuery(idsBySelectionQuery);
        this.queryFinder.setIdsBySelectionQuery(query);
    }

    public void setIdsByMilestoneQuery(Resource idsByMilestoneQuery) {
        String query = this.loadQuery(idsByMilestoneQuery);
        this.queryFinder.setIdsByMilestoneQuery(query);
    }

    public void setTestCaseDataQuery(Resource testCaseDataQuery) {
        String query = this.loadQuery(testCaseDataQuery);
        this.queryFinder.setTestCasesQuery(query);
    }

    public void setLinkedReqDataQuery(Resource linkedReqDataQuery) {
        String query = this.loadQuery(linkedReqDataQuery);
        this.queryFinder.setLinkedReqQuery(query);
    }

    public void setTestCaseStepsDataQuery(Resource testCaseStepsDataQuery) {
        String query = this.loadQuery(testCaseStepsDataQuery);
        this.queryFinder.setTestCaseStepsQuery(query);
    }

    public void setBddActionFragmentsDataQuery(Resource bddActionFragmentsDataQuery) {
        String query = this.loadQuery(bddActionFragmentsDataQuery);
        this.queryFinder.setBddActionFragmentsQuery(query);
    }

    public void setCufsDataQuery(Resource cufsDataQuery) {
        String query = this.loadQuery(cufsDataQuery);
        this.queryFinder.setCufQuery(query);
    }

    public void setNumCufsDataQuery(Resource numCufsDataQuery) {
        String query = this.loadQuery(numCufsDataQuery);
        this.queryFinder.setNumCufQuery(query);
    }

    public void setTagCufsDataQuery(Resource tagCufsDataQuery) {
        String query = this.loadQuery(tagCufsDataQuery);
        this.queryFinder.setTagCufQuery(query);
    }

    public void setRtfCufsDataQuery(Resource rtfCufsDataQuery) {
        String query = this.loadQuery(rtfCufsDataQuery);
        this.queryFinder.setRtfCufQuery(query);
    }

    public void setNodesByTestCaseIdsDataQuery(Resource nodesByTestCaseIdsDataQuery) {
        String query = this.loadQuery(nodesByTestCaseIdsDataQuery);
        this.queryFinder.setNodesByTestCaseIdsQuery(query);
    }

    public void setNodesByMilestonesDataQuery(Resource nodesByMilestonesDataQuery) {
        String query = this.loadQuery(nodesByMilestonesDataQuery);
        this.queryFinder.setNodesByMilestonesQuery(query);
    }

    public void setNodesByTagsDataQuery(Resource nodesByTagsDataQuery) {
        String query = this.loadQuery(nodesByTagsDataQuery);
        this.queryFinder.setNodesByTagsQuery(query);
    }

    public void setNodesByProjectIdsDataQuery(Resource nodesByProjectIdsDataQuery) {
        String query = this.loadQuery(nodesByProjectIdsDataQuery);
        this.queryFinder.setNodesByProjectIdsQuery(query);
    }

    public void setStepsByCallStepDataQuery(Resource stepsByCallStepDataQuery) {
        String query = this.loadQuery(stepsByCallStepDataQuery);
        this.queryFinder.setTestStepsByCallSteps(query);
    }

    public void setLinkedReqByStepsDataQuery(Resource stepsByCallStepDataQuery) {
        String query = this.loadQuery(stepsByCallStepDataQuery);
        this.queryFinder.setLinkedReqByTestStepQuery(query);
    }

    public void setMilestoneConfigurationQuery(Resource milestoneConfigurationQuery) {
        String query = this.loadQuery(milestoneConfigurationQuery);
        this.queryFinder.setMilestoneConfigurationQuery(query);
    }

    public void setParameterDataQuery(Resource parameterDataQuery) {
        String query = this.loadQuery(parameterDataQuery);
        this.queryFinder.setParametersQuery(query);
    }

    public void setDataSetDataQuery(Resource dataSetDataQuery) {
        String query = this.loadQuery(dataSetDataQuery);
        this.queryFinder.setDataSetQuery(query);
    }

    public void setDataSetParamValueDataQuery(Resource dataSetParamValueDataQuery) {
        String query = this.loadQuery(dataSetParamValueDataQuery);
        this.queryFinder.setDataSetParamValueQuery(query);
    }

    protected String loadQuery(Resource query) {
        InputStream is;
        try {
            is = query.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Scanner(is, "UTF-8").useDelimiter("\\A").next();
    }

    private void addCalledSteps(Collection<TestCaseSteps> stepsBeans, Collection<TestCaseSteps> allSteps, boolean printAttachment, boolean printStepLinkedReq, boolean printStepCufs) {
        for (TestCaseSteps testCaseStepsBean : stepsBeans) {
            if ("C".equals(testCaseStepsBean.getType())) {
                Long id = testCaseStepsBean.getId();
                Collection<Object[]> objects = this.queryFinder.getTestCaseStepsData(id);
                testCaseStepsBean.getDataset();
                Collection<TestCaseSteps> testCaseStepsBeans = this.formatter.toCallStepBean(objects, testCaseStepsBean.getTestCaseId(), printAttachment, printStepLinkedReq, printStepCufs);
                this.addCalledSteps(testCaseStepsBeans, allSteps, printAttachment, printStepLinkedReq, printStepCufs);
                continue;
            }
            allSteps.add(testCaseStepsBean);
        }
    }

    private List<Project> populateProjectFromNode(List<Node> nodesBeans) {
        LinkedHashMap<Long, Project> map = new LinkedHashMap<Long, Project>();
        for (Node node : nodesBeans) {
            Project p = (Project)map.get(node.getProjectId());
            if (p != null) {
                p.addTestCases(node.getTestCasesBeans());
                continue;
            }
            p = new Project();
            p.setProjectId(node.getProjectId());
            p.setProjectName(node.getProjectName());
            p.setTestCases(node.getTestCasesBeans());
            map.put(p.getProjectId(), p);
        }
        return new ArrayList<Project>(map.values());
    }

    private void processRichText(List<Node> nodesBeans, List<String> html) {
        for (Node nodes : nodesBeans) {
            this.richTextForTc(nodes.getTestCasesBeans(), html);
        }
    }

    private void richTextForTc(List<TestCase> tcs, List<String> html) {
        for (TestCase tc : tcs) {
            tc.setDescription(this.formatter.richTextReplace(tc.getDescription(), html));
            tc.setPrerequisites(this.formatter.richTextReplace(tc.getPrerequisites(), html));
            if (!tc.isScriptEmpty()) {
                tc.setScript(this.replaceScriptString(tc.getScript(), html));
            }
            this.richTextForParameter(tc.getParameters(), html);
            this.richTextForStep(tc.getTcSteps(), html);
        }
    }

    private String replaceScriptString(String initScript, List<String> html) {
        initScript = HtmlUtils.htmlEscape((String)initScript);
        initScript = initScript.replaceAll("\\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        initScript = initScript.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        initScript = initScript.replaceAll("\\n", "<br />");
        return this.formatter.richTextReplace("<p>" + initScript + "</p>", html);
    }

    private void richTextForStep(List<TestCaseSteps> steps, List<String> html) {
        for (TestCaseSteps step : steps) {
            if ("C".equals(step.getType())) {
                step.setAction(HtmlUtils.htmlEscape((String)step.getAction()));
            }
            step.setAction(this.formatter.richTextReplace(step.getAction(), html));
            step.setExpectedResult(this.formatter.richTextReplace(step.getExpectedResult(), html));
        }
    }

    private void richTextForParameter(List<Parameter> parameters, List<String> html) {
        for (Parameter param : parameters) {
            param.setDescription(this.formatter.richTextReplace(param.getDescription(), html));
        }
    }

    private void processChain(List<Node> nodeBeans) {
        String previousChain = null;
        String folderDescription = "";
        for (Node nodes : nodeBeans) {
            for (TestCase tc : nodes.getTestCasesBeans()) {
                if (!tc.isFolder()) {
                    boolean shouldReprint = !tc.getChain().equals(previousChain);
                    previousChain = tc.getChain();
                    tc.setPrintChain(shouldReprint);
                    folderDescription = this.folderDescriptionForTestCase(tc, folderDescription);
                    continue;
                }
                folderDescription = tc.getDescription();
            }
        }
    }

    private String folderDescriptionForTestCase(TestCase tc, String folderDescription) {
        if (!"".equals(folderDescription)) {
            tc.setChainDescription(folderDescription);
        }
        return "";
    }

    private Collection addNodesIds(Criteria idsCrit) {
        if (idsCrit != null) {
            Collection ids = ((Map)idsCrit.getValue()).values();
            if (!ids.isEmpty()) {
                HashSet nodesIds = new HashSet();
                nodesIds.addAll(ids);
                return nodesIds;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private boolean isMilestonePicker(Map<String, Criteria> criteriaMap) {
        Criteria selectionMode = criteriaMap.get(CriteriaEntry.TEST_CASES_SELECTION_MODE.getValue());
        return MILESTONE_PICKER.equals(selectionMode.getValue());
    }
}

