/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.helpers;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import jirasync.com.atlassian.jira.rest.client.api.NamedEntity;
import jirasync.com.atlassian.jira.rest.client.api.domain.Issue;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueField;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonParser;
import jirasync.org.codehaus.jackson.JsonNode;
import jirasync.org.codehaus.jackson.map.ObjectMapper;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.mapping.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.OAuth2Credentials;
import org.squashtest.tm.plugin.jirasync.helpers.AsIsValueFinder;
import org.squashtest.tm.plugin.jirasync.helpers.CompositeValueFinder;
import org.squashtest.tm.plugin.jirasync.helpers.EmptyValueFinder;
import org.squashtest.tm.plugin.jirasync.helpers.IssueFieldValueFinder;
import org.squashtest.tm.plugin.jirasync.helpers.JiraValue;
import org.squashtest.tm.plugin.jirasync.helpers.JiraValueFinder;
import org.squashtest.tm.plugin.jirasync.helpers.NamedEntityValueFinder;
import org.squashtest.tm.plugin.jirasync.helpers.NullValueFinder;
import org.squashtest.tm.plugin.jirasync.service.SynchronisationEffectiveConfiguration;

@Component(value="squash.tm.plugin.jirasync.jiraHelper")
@Scope(value="prototype")
public final class JiraHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraHelper.class);
    private static final String CUF_FAIL_LOG_HEADER = "could not create custom field ";
    private static final String HTTP_AUTHORIZATION = "Authorization";
    private static final String ATLASSIAN_TOKEN_ACCESSIBLE_RESOURCES_API_ENDPOINT = "https://api.atlassian.com/oauth/token/accessible-resources";
    private static final String ATLASSIAN_SERVER_INFO_API_ENDPOINT = "/rest/api/latest/serverInfo";
    @Inject
    @Named(value="squash.tm.plugin.jirasync.mappings.valuefinders")
    private Properties valueFinders;
    @Inject
    @Named(value="squash.tm.plugin.jirasync.mappings.parsers")
    private Properties cufsParsers;
    @Inject
    @Named(value="squash.tm.plugin.jirasync.mappings.domain")
    private Properties cufsDomain;
    private static final Map<String, String> IRREGULAR_GETTERS = new HashMap<String, String>();
    private Map<String, Method> methodMap = new HashMap<String, Method>();
    private Map<String, JiraValueFinder> usefulFinders = new HashMap<String, JiraValueFinder>();
    private Set<String> treatAsCustomfield = new HashSet<String>();

    static {
        IRREGULAR_GETTERS.put("issuekey", "getKey");
        IRREGULAR_GETTERS.put("created", "getCreationDate");
        IRREGULAR_GETTERS.put("comment", "getComments");
        IRREGULAR_GETTERS.put("versions", "getAffectedVersions");
    }

    public JiraHelper() {
        this.registerIrregularGetters();
    }

    public String getRelatedEpic(Issue issue, String epicLinkId) {
        IssueField field = issue.getField(epicLinkId);
        if (field != null) {
            return (String)field.getValue();
        }
        return null;
    }

    public JiraValue getFieldValue(Issue issue, SynchronisationEffectiveConfiguration.EffectiveMapping fieldMapping) {
        Object field = null;
        String fieldId = fieldMapping.getJiraField();
        field = this.extractField(issue, fieldMapping);
        JiraValueFinder valueFinder = field == null ? NullValueFinder.INSTANCE : (this.knowsFinder(fieldId) ? this.usefulFinders.get(fieldId) : this.registerFinder(field, fieldMapping));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("processing field '" + fieldId + "' with value processor '" + ((Object)valueFinder).toString() + "'");
        }
        JiraValue value = valueFinder.getValue(field);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("value found for field '" + fieldId + "' : '" + String.valueOf(value) + "'");
        }
        return value;
    }

    public String getJiraInstanceType(String serverUrl) {
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
        String deploymentType = null;
        String btUrl = serverUrl.replaceAll("\\/*$", "");
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(btUrl + ATLASSIAN_SERVER_INFO_API_ENDPOINT)).GET().build();
            HttpResponse<String> httpResponse = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            String responseBody = httpResponse.body();
            int statusCode = httpResponse.statusCode();
            if (statusCode == 200) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode serverInfo = mapper.readTree(responseBody);
                deploymentType = serverInfo.get("deploymentType").asText();
            }
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            LOGGER.error("Error while retrieving Jira Instance Type", (Throwable)e);
        }
        return deploymentType;
    }

    public String getCloudIdForOauth2ApiRequest(BugTracker bugtracker, OAuth2Credentials credentials) {
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
        String cloudId = null;
        String tokenType = StringUtils.capitalize((String)credentials.getTokenType());
        try {
            HttpRequest request = HttpRequest.newBuilder().header(HTTP_AUTHORIZATION, tokenType + " " + credentials.getAccessToken()).uri(new URI(ATLASSIAN_TOKEN_ACCESSIBLE_RESOURCES_API_ENDPOINT)).GET().build();
            HttpResponse<String> httpResponse = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            String responseBody = httpResponse.body();
            int statusCode = httpResponse.statusCode();
            if (statusCode == 200) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsJiraInstances = mapper.readTree(responseBody);
                cloudId = JiraHelper.retrieveCloudIdByInstance(bugtracker, jsJiraInstances);
            }
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            LOGGER.error("Error while retrieving Oauth2 Jira Cloud ID", (Throwable)e);
        }
        return cloudId;
    }

    private static String retrieveCloudIdByInstance(BugTracker server, JsonNode jsJiraInstances) {
        int i = 0;
        while (i < jsJiraInstances.size()) {
            JsonNode obj = jsJiraInstances.get(i);
            String btUrl = server.getUrl().replaceAll("\\/*$", "");
            String jiraInstanceUrl = obj.get("url").asText();
            if (jiraInstanceUrl.equals(btUrl)) {
                return obj.get("id").asText();
            }
            ++i;
        }
        return null;
    }

    private Object extractField(Issue issue, SynchronisationEffectiveConfiguration.EffectiveMapping fieldMapping) {
        Object field;
        String fieldId = fieldMapping.getJiraField();
        boolean custom = this.retrieveAsCustomfield(fieldMapping);
        if (custom) {
            field = issue.getField(fieldId);
        } else {
            Method m;
            Method method = m = this.knowsMethod(fieldId) ? this.methodMap.get(fieldId) : this.locateAndRegisterMethod(fieldId);
            if (m != null) {
                field = ReflectionUtils.invokeMethod((Method)m, (Object)issue);
            } else {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("attempting to retrieve the field '" + fieldId + "' as a custom field");
                }
                if ((field = issue.getField(fieldId)) == null) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("failed to load field '" + fieldId + "' either as a first-class attribute or a custom field, that field will be skipped from now on");
                    }
                } else {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("found out that field '" + fieldId + "' is actually treated as a custom field. From now on it will be retrieved as such");
                    }
                    this.treatAsCustomfield.add(fieldId);
                }
            }
        }
        return field;
    }

    private final void registerIrregularGetters() {
        for (Map.Entry<String, String> irregular : IRREGULAR_GETTERS.entrySet()) {
            String attribute = irregular.getKey();
            String getter = irregular.getValue();
            try {
                Method getMethod = Issue.class.getMethod(getter, null);
                this.methodMap.put(attribute, getMethod);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Method '" + getter + "' could not be located in jira class 'Issue', which is weird. Proceeding anyway, this field will not be processed though.", (Throwable)e);
            }
            catch (SecurityException e) {
                LOGGER.error("The security manager from this VM doesn't allow for introspection. The plugin will just not work at all. This is not a bug on the plugin end, but a matter that must be discussed with your IT guys.", (Throwable)e);
            }
        }
    }

    private Method locateAndRegisterMethod(String fieldId) {
        Method[] allMethods;
        String getterName = "get" + fieldId;
        Method m = null;
        Method[] methodArray = allMethods = Issue.class.getDeclaredMethods();
        int n = allMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method iter = methodArray[n2];
            if (iter.getName().toLowerCase().equals(getterName.toLowerCase()) && iter.getParameterTypes().length == 0) {
                m = iter;
                break;
            }
            ++n2;
        }
        this.methodMap.put(fieldId, m);
        if (m == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("could not find dedicated getter for issue field '" + fieldId + "'");
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("found getter method for issue field '" + fieldId + "', getter is '" + m.getName() + "'");
        }
        return m;
    }

    private boolean knowsMethod(String fieldName) {
        return this.methodMap.containsKey(fieldName);
    }

    private boolean knowsFinder(String fieldName) {
        return this.usefulFinders.containsKey(fieldName);
    }

    private boolean isComposite(Object field) {
        Class<?> clazz = field.getClass();
        return Collection.class.isAssignableFrom(clazz) || Iterable.class.isAssignableFrom(clazz);
    }

    private JiraValueFinder registerFinder(Object fieldInstance, SynchronisationEffectiveConfiguration.EffectiveMapping fieldMapping) {
        JiraValueFinder finder;
        String fieldId = fieldMapping.getJiraField();
        boolean shouldRegister = true;
        if (fieldInstance == null) {
            LOGGER.trace("");
            finder = NullValueFinder.INSTANCE;
            shouldRegister = false;
        } else if (this.retrieveAsCustomfield(fieldMapping)) {
            finder = this.locateCustomFinder(fieldMapping);
        } else {
            try {
                finder = this.locateNativeFinder(fieldInstance, fieldMapping);
            }
            catch (UnconclusiveException unconclusiveException) {
                shouldRegister = false;
                finder = EmptyValueFinder.INSTANCE;
            }
        }
        if (shouldRegister) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("registering value finder '" + finder.toString() + "' for field '" + fieldId + "'");
            }
            this.usefulFinders.put(fieldId, finder);
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("cannot yet register value finder for field '" + fieldId + "'");
        }
        return finder;
    }

    private JiraValueFinder locateNativeFinder(Object fieldInstance, SynchronisationEffectiveConfiguration.EffectiveMapping mapping) throws UnconclusiveException {
        JiraValueFinder finder;
        Class<?> clazz = fieldInstance.getClass();
        if (this.isComposite(fieldInstance)) {
            Iterable field = (Iterable)fieldInstance;
            boolean hasNext = field.iterator().hasNext();
            if (!hasNext) {
                throw new UnconclusiveException();
            }
            Object sample = field.iterator().next();
            if (sample == null) {
                throw new UnconclusiveException();
            }
            Class<?> sampleClass = sample.getClass();
            JiraValueFinder itemFinder = this.lookupFinder(sampleClass);
            finder = new CompositeValueFinder(itemFinder);
        } else {
            finder = this.lookupFinder(clazz);
        }
        return finder;
    }

    private JiraValueFinder locateCustomFinder(SynchronisationEffectiveConfiguration.EffectiveMapping mapping) {
        boolean isArray;
        String type = mapping.getType();
        String items = mapping.getItems();
        String restTypename = switch (type) {
            case "array" -> {
                isArray = true;
                yield items;
            }
            default -> {
                isArray = false;
                yield type;
            }
        };
        Class<?> actualClass = this.lookupClass(restTypename);
        JsonParser<?, ?> parser = this.lookupParser(restTypename);
        JiraValueFinder finder = this.lookupFinder(actualClass);
        if (isArray) {
            finder = new CompositeValueFinder(finder);
        }
        IssueFieldValueFinder valueFinder = IssueFieldValueFinder.create(isArray, parser, finder);
        return valueFinder;
    }

    private JiraValueFinder lookupFinder(Class<?> fieldClass) {
        JiraValueFinder finder = null;
        String finderClassname = this.valueFinders.getProperty(fieldClass.getName());
        if (finderClassname != null) {
            finder = this.createValuefinder(finderClassname);
        } else if (NamedEntity.class.isAssignableFrom(fieldClass)) {
            finder = NamedEntityValueFinder.INSTANCE;
        } else if (ClassUtils.isPrimitiveOrWrapper(fieldClass)) {
            finder = AsIsValueFinder.INSTANCE;
        }
        if (finder == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("cannot locate a value finder that could be used for fields of class '" + fieldClass.getName() + "', defaulting to EmptyValueFinder");
            }
            finder = EmptyValueFinder.INSTANCE;
        }
        return finder;
    }

    private Class<?> lookupClass(String restTypename) {
        String actualClassname = "uninitialized";
        try {
            actualClassname = this.cufsDomain.getProperty(restTypename);
            if (actualClassname == null) {
                throw new IllegalArgumentException("could not create custom field because don't know which class the unknown REST-type '" + restTypename + "' should be deserialized to");
            }
            return this.getClass().getClassLoader().loadClass(actualClassname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("could not create custom field because expected to find implementation '" + actualClassname + "' for REST-type '" + restTypename + "', but was not found");
        }
    }

    private JsonParser<?, ?> lookupParser(String restTypename) {
        String parserClassname = "uninitialized";
        try {
            parserClassname = this.cufsParsers.getProperty(restTypename);
            if (parserClassname == null) {
                throw new IllegalArgumentException("could not create custom field because don't know which json parser to use for unknown REST-type '" + restTypename + "'");
            }
            Class<?> parserClass = this.getClass().getClassLoader().loadClass(parserClassname);
            return (JsonParser)parserClass.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("could not create custom field because expected to find json parser '" + parserClassname + "' for REST-type '" + restTypename + "', but was not found");
        }
        catch (IllegalAccessException | InstantiationException ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
            throw new IllegalArgumentException("could not create custom field because an error occured when creating instance of json parser '" + parserClassname + "' ('" + ex.getClass().getName() + "'");
        }
    }

    private JiraValueFinder createValuefinder(String finderClassname) {
        try {
            Class<?> valuefinderClass = this.getClass().getClassLoader().loadClass(finderClassname);
            return (JiraValueFinder)valuefinderClass.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("could not create custom field because could not find JiraValueFinder implementation '" + finderClassname + "'");
        }
        catch (IllegalAccessException | InstantiationException ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
            throw new IllegalArgumentException("could not create custom field because an error occured when creating instance of JiraValueFinder implementation '" + finderClassname + "' ('" + ex.getClass().getName() + "'");
        }
    }

    private boolean retrieveAsCustomfield(SynchronisationEffectiveConfiguration.EffectiveMapping mapping) {
        return this.treatAsCustomfield.contains(mapping.getJiraField()) || mapping.isCustom();
    }

    private static final class UnconclusiveException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private UnconclusiveException() {
        }
    }
}

