/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.nio.conn;

import java.util.concurrent.TimeUnit;
import jirasync.org.apache.http.annotation.Contract;
import jirasync.org.apache.http.annotation.ThreadingBehavior;
import jirasync.org.apache.http.conn.routing.HttpRoute;
import jirasync.org.apache.http.impl.nio.conn.CPoolEntry;
import jirasync.org.apache.http.nio.NHttpClientConnection;
import jirasync.org.apache.http.nio.conn.ManagedNHttpClientConnection;
import jirasync.org.apache.http.nio.pool.AbstractNIOConnPool;
import jirasync.org.apache.http.nio.pool.NIOConnFactory;
import jirasync.org.apache.http.nio.pool.SocketAddressResolver;
import jirasync.org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Contract(threading=ThreadingBehavior.SAFE)
class CPool
extends AbstractNIOConnPool<HttpRoute, ManagedNHttpClientConnection, CPoolEntry> {
    private final Log log = LogFactory.getLog(CPool.class);
    private final long timeToLive;
    private final TimeUnit timeUnit;

    public CPool(ConnectingIOReactor ioReactor, NIOConnFactory<HttpRoute, ManagedNHttpClientConnection> connFactory, SocketAddressResolver<HttpRoute> addressResolver, int defaultMaxPerRoute, int maxTotal, long timeToLive, TimeUnit timeUnit) {
        super(ioReactor, connFactory, addressResolver, defaultMaxPerRoute, maxTotal);
        this.timeToLive = timeToLive;
        this.timeUnit = timeUnit;
    }

    @Override
    protected CPoolEntry createEntry(HttpRoute route, ManagedNHttpClientConnection conn) {
        CPoolEntry entry = new CPoolEntry(this.log, conn.getId(), route, conn, this.timeToLive, this.timeUnit);
        entry.setSocketTimeout(conn.getSocketTimeout());
        return entry;
    }

    @Override
    protected void onLease(CPoolEntry entry) {
        NHttpClientConnection conn = (NHttpClientConnection)entry.getConnection();
        conn.setSocketTimeout(entry.getSocketTimeout());
    }

    @Override
    protected void onRelease(CPoolEntry entry) {
        NHttpClientConnection conn = (NHttpClientConnection)entry.getConnection();
        conn.setSocketTimeout(0);
    }
}

