/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.beans;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.squashtest.tm.plugin.report.books.requirements.beans.Cuf;
import org.squashtest.tm.plugin.report.books.requirements.beans.I18nHelper;
import org.squashtest.tm.plugin.report.books.requirements.beans.ReqLink;
import org.squashtest.tm.plugin.report.books.requirements.beans.RequirementStructure;
import org.squashtest.tm.plugin.report.books.requirements.beans.TestCase;

public class RequirementVersion
extends RequirementStructure {
    private Long versionNumber;
    private String status;
    private String criticality;
    private String category;
    private String categoryType;
    private String nature;
    private String createdBy;
    private Date createdOn;
    private String modifyBy;
    private Date modifyOn;
    private Long attachments;
    private String description;
    private Long reqId;
    private List<Cuf> cufs = new ArrayList<Cuf>();
    private List<TestCase> testCases;
    private List<ReqLink> reqLinks;
    private static final I18nHelper translator = new I18nHelper();

    public boolean isModify() {
        return !this.modifyBy.isEmpty();
    }

    public boolean isHasTestCases() {
        return this.testCases != null;
    }

    public boolean isHasReqLinks() {
        return this.reqLinks != null;
    }

    public boolean isHasCufs() {
        return !this.cufs.isEmpty();
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getStatus() {
        return translator.getRequirementStatus(this.status);
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCriticality() {
        return translator.getRequirementCriticality(this.criticality);
    }

    public void setCriticality(String criticality) {
        this.criticality = criticality;
    }

    public String getCategory() {
        return translator.getRequirementCategory(this.category, this.categoryType);
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setCategoryType(String categoryType) {
        this.categoryType = categoryType;
    }

    public String getNature() {
        return this.nature;
    }

    public void setNature(boolean isHlr) {
        this.nature = isHlr ? I18nHelper.translate("report.books.requirements.nature.highLevel") : I18nHelper.translate("report.books.requirements.nature.classic");
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedOn() {
        return I18nHelper.translate(this.createdOn);
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String getModifyBy() {
        return this.modifyBy;
    }

    public void setModifyBy(String modifyBy) {
        this.modifyBy = modifyBy;
    }

    public String getModifyOn() {
        return I18nHelper.translate(this.modifyOn);
    }

    public void setModifyOn(Date modifyOn) {
        this.modifyOn = modifyOn;
    }

    public Long getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Long attachments) {
        this.attachments = attachments;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getReqId() {
        return this.reqId;
    }

    public void setReqId(Long reqId) {
        this.reqId = reqId;
    }

    public List<Cuf> getCufs() {
        return this.cufs;
    }

    public List<TestCase> getTestCases() {
        return this.testCases;
    }

    public void setTestCases(List<TestCase> testCases) {
        this.testCases = testCases;
    }

    public List<ReqLink> getReqLinks() {
        return this.reqLinks;
    }

    public void setReqLinks(List<ReqLink> reqLinks) {
        this.reqLinks = reqLinks;
    }

    public void orderTestCases() {
        if (this.isHasTestCases()) {
            this.testCases.sort((tc1, tc2) -> new CompareToBuilder().append(tc1.getImportanceLevel(), tc2.getImportanceLevel()).append((Object)tc1.getProjectName(), (Object)tc2.getProjectName()).append((Object)tc1.getTcRef(), (Object)tc2.getTcRef()).append((Object)tc1.getTcName(), (Object)tc2.getTcName()).toComparison());
        }
    }
}

