/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.books.requirements.beans;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component(value="report.books.requirements.i18nHelper")
public class I18nHelper
implements MessageSourceAware {
    private static MessageSource msgSource;

    private static Locale currentLocale() {
        return LocaleContextHolder.getLocale();
    }

    public static String translate(String string) {
        return msgSource.getMessage(string, null, I18nHelper.currentLocale());
    }

    public static String translate(String string, Object[] params) {
        return msgSource.getMessage(string, params, I18nHelper.currentLocale());
    }

    public static String translate(Date date) {
        String dateFormat = msgSource.getMessage("squashtm.dateformat", null, I18nHelper.currentLocale());
        return new SimpleDateFormat(dateFormat).format(date);
    }

    public void setMessageSource(MessageSource messageSource) {
        msgSource = messageSource;
    }

    public String getRequirementCategory(String category, String categoryType) {
        if (categoryType.equals("SYS")) {
            return I18nHelper.translate("report.books.requirements." + category.toLowerCase());
        }
        return category;
    }

    public String getRequirementCriticality(String criticality) {
        return I18nHelper.translate(switch (criticality) {
            case "MAJOR" -> "report.books.requirements.criticality.major";
            case "MINOR" -> "report.books.requirements.criticality.minor";
            case "CRITICAL" -> "report.books.requirements.criticality.critical";
            default -> "report.books.requirements.criticality.undefined";
        });
    }

    public String getRequirementStatus(String status) {
        return I18nHelper.translate(switch (status) {
            case "APPROVED" -> "report.books.requirements.status.approved";
            case "OBSOLETE" -> "report.books.requirements.status.obsolete";
            case "UNDER_REVIEW" -> "report.books.requirements.status.under_review";
            default -> "report.books.requirements.status.work_in_progress";
        });
    }

    public String getTestCaseStatus(String status) {
        return I18nHelper.translate(switch (status) {
            case "TO_BE_UPDATED" -> "report.books.requirements.testcases.status.to_be_updated";
            case "UNDER_REVIEW" -> "report.books.requirements.testcases.status.under_review";
            case "APPROVED" -> "report.books.requirements.testcases.status.approved";
            case "OBSOLETE" -> "report.books.requirements.testcases.status.obsolete";
            default -> "report.books.requirements.testcases.status.work_in_progress";
        });
    }

    public String getTestCaseImportance(String importance) {
        return I18nHelper.translate(switch (importance) {
            case "LOW" -> "report.books.requirements.testcases.importance.low";
            case "MEDIUM" -> "report.books.requirements.testcases.importance.medium";
            case "HIGH" -> "report.books.requirements.testcase.importance.high";
            case "VERY_HIGH" -> "report.books.requirements.testcases.importance.very_high";
            default -> "report.books.requirements.testcases.importance.undefined";
        });
    }
}

