/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3;

import com.taskadapter.redmineapi.NotAuthorizedException;
import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.bugtracker.redmine3.Redmine3Client;
import org.squashtest.tm.plugin.bugtracker.redmine3.RedmineAdvancedIssue;
import org.squashtest.tm.plugin.bugtracker.redmine3.command.DelegateCommands;
import org.squashtest.tm.plugin.bugtracker.redmine3.converter.EntityConverter;
import org.squashtest.tm.plugin.bugtracker.redmine3.exception.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.utils.BaseCommunicatorFactory;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;

@Component
@Scope(value="prototype")
public class Redmine3Connector
implements AdvancedBugTrackerConnector {
    private static final String ISSUE_URL_SUFFIX = "/issues/";
    @Inject
    private Redmine3Client client;
    private BugTracker bugTracker;
    @Inject
    private ExceptionHandler exceptionHandler;
    @Inject
    @Named(value="redmine3BugTrackerInterfaceDescriptor")
    private BugTrackerInterfaceDescriptor descriptor;
    @Inject
    private EntityConverter converter;
    @Inject
    private BaseCommunicatorFactory baseCommunicatorFactory;

    public void setBugTracker(BugTracker bugTracker) {
        this.bugTracker = bugTracker;
    }

    public void authenticate(Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.client.init(this.bugTracker, credentials, this.baseCommunicatorFactory);
    }

    public void checkCredentials(Credentials credentials) {
        this.authenticate(credentials);
        this.checkCredentials();
    }

    private void checkCredentials() {
        this.client.getCurrentUser();
    }

    public AdvancedIssue createIssue(RemoteIssue issue) {
        AdvancedIssue advancedIssue = (AdvancedIssue)issue;
        String projectKey = advancedIssue.getProject().getId();
        this.checkIssueCreatePermission(projectKey);
        Project project = this.client.findProjectForCreateByKey(projectKey);
        String issueTypeName = advancedIssue.getCurrentScheme().split(":")[1];
        User author = this.client.getCurrentUser();
        Issue inputIssue = this.converter.squash2redmineIssue(advancedIssue, this.getIssueType(projectKey, issueTypeName), project, author);
        this.client.verifyAssigneAssignable(inputIssue);
        this.client.insertIdForCustomFields(inputIssue);
        this.client.insertIdForAssignee(inputIssue);
        Issue createdIssue = this.client.createIssue(inputIssue);
        Issue redmineIssue = this.client.getIssue(createdIssue.getId().toString());
        return this.converter.redmine2squashIssue(redmineIssue);
    }

    public RemoteIssue createReportIssueTemplate(String projectName, RemoteIssueContext context) {
        return this.createReportIssueTemplate(projectName);
    }

    public AuthenticationProtocol[] getSupportedAuthProtocols() {
        return new AuthenticationProtocol[]{AuthenticationProtocol.BASIC_AUTH, AuthenticationProtocol.TOKEN_AUTH};
    }

    private void checkIssueCreatePermission(String projectKey) {
        Iterable<User> users = this.client.searchPossisbleReporter(projectKey, this.client.getCurrentUser().getFullName());
        if (!users.iterator().hasNext()) {
            this.exceptionHandler.notAuthorizedException(new NotAuthorizedException(""));
        }
    }

    public RemoteIssue createReportIssueTemplate(String projectName) {
        AdvancedProject project = this.getProjectForCreate(projectName);
        String key = project.getSchemeMap().containsKey("Tracker:Anomalie") ? "Tracker:Anomalie" : (String)project.getSchemeMap().keySet().stream().findFirst().orElseThrow();
        Collection fields = project.getFieldScheme(key);
        RedmineAdvancedIssue issue = new RedmineAdvancedIssue();
        issue.setProject(project);
        issue.setBugtracker(this.bugTracker.getName());
        issue.setCurrentScheme(key);
        for (Field field : fields) {
            issue.setFieldValue(field.getId(), null);
        }
        return issue;
    }

    public Object executeDelegateCommand(DelegateCommand command) {
        FieldValue fieldValue = null;
        if (DelegateCommands.isSearchAssignableCommand(command)) {
            String projectKey = DelegateCommands.getProjectFromCommand(command);
            Iterable<User> users = this.client.searchAssignableUsers(projectKey, (String)command.getArgument());
            fieldValue = this.converter.convertToUserCompositeFieldValue(users);
        } else if (DelegateCommands.isSearchReporterCommand(command)) {
            String projectKey = DelegateCommands.getProjectFromCommand(command);
            Iterable<User> users = this.client.searchPossisbleReporter(projectKey, (String)command.getArgument());
            fieldValue = this.converter.convertToUserCompositeFieldValue(users);
        } else {
            fieldValue = new FieldValue();
        }
        return fieldValue;
    }

    public void linkIssues(String remoteIssueKey, List<String> remoteReqIds) {
    }

    public AdvancedIssue findIssue(String issueKey) {
        Issue issue = this.client.getIssue(issueKey);
        AdvancedIssue advancedIssue = this.converter.redmine2squashIssue(issue);
        String schemeName = advancedIssue.getCurrentScheme();
        AdvancedProject project = this.converter.createReadOnlyProjectStub(schemeName, this.descriptor);
        project.setId(issue.getProject().getId().toString());
        project.setName(issue.getProject().getName());
        advancedIssue.setProject(project);
        return advancedIssue;
    }

    public List<AdvancedIssue> findIssues(List<String> issueKeys) {
        List<Issue> issueList = this.client.getIssues(issueKeys);
        return this.converter.redmine2SquashIssues(issueList);
    }

    public AdvancedProject findProject(String projectKey) {
        Project redmineProject = this.client.findProjectForCreateByKey(projectKey);
        return this.converter.redmine2SquashProject(redmineProject);
    }

    public AdvancedProject findProjectById(String projectId) {
        Integer projectIdAsInt = Integer.valueOf(projectId);
        Project redmineProject = this.client.findProjectForCreateById(projectIdAsInt);
        return this.converter.redmine2SquashProject(redmineProject);
    }

    public void forwardAttachments(String remoteIssueKey, List<org.squashtest.tm.bugtracker.definition.Attachment> attachments) {
        Collection<Attachment> redmineAttachments = this.converter.convertToRedmineAttachments(attachments, this.client);
        this.client.forwardAttachments(remoteIssueKey, redmineAttachments);
    }

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor() {
        return this.descriptor;
    }

    public URL makeViewIssueUrl(String issueId) {
        String strUrl = String.valueOf(this.bugTracker.getUrl().replaceAll("\\/$", "")) + ISSUE_URL_SUFFIX + issueId;
        try {
            return new URL(strUrl);
        }
        catch (MalformedURLException e) {
            this.exceptionHandler.genericError(e);
            return null;
        }
    }

    private Tracker getIssueType(String projectKey, String issueTypeName) {
        Tracker result = null;
        Project project = this.client.findProjectForCreateByKey(projectKey);
        for (Tracker tracker : project.getTrackers()) {
            if (!tracker.getName().equals(issueTypeName)) continue;
            result = tracker;
        }
        return result;
    }

    private AdvancedProject getProjectForCreate(String projectName) {
        String pKey = this.client.findProjectKeyByName(projectName);
        Project redmineProject = this.client.findProjectForCreateByKey(pKey);
        return this.converter.redmine2SquashProject(redmineProject);
    }
}

