/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.service;

import gitlabbt.org.gitlab4j.api.GitLabApiException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.api.plugin.EntityType;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.helper.EmojiStringHelper;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.GitLabApiWrapper;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.ScopedLabelHelper;
import org.squashtest.tm.plugin.bugtracker.gitlab.configuration.ConfigurationPage;
import org.squashtest.tm.plugin.bugtracker.gitlab.configuration.ProjectMappings;
import org.squashtest.tm.plugin.bugtracker.gitlab.exceptions.BadBugTrackerConfigurationException;
import org.squashtest.tm.plugin.bugtracker.gitlab.exceptions.CannotReachGitLabServerException;
import org.squashtest.tm.plugin.bugtracker.gitlab.service.ConfigurationDao;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.internal.display.dto.BugTrackerDto;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.servers.CredentialsProvider;

@Service(value="squash.tm.plugin.bugtracker.gitlab.ConfigurationService")
@Transactional
public class ConfigurationService {
    public static final String CONFIGURATION_ERROR_MESSAGE = "Could not load configuration for project ";
    private final ConfigurationDao dao;
    private final GenericProjectManagerService projectManager;
    private final CredentialsProvider credentialsProvider;
    private final BugTrackerFinderService bugTrackerFinderService;

    public ConfigurationService(ConfigurationDao dao, GenericProjectManagerService projectManager, @Lazy CredentialsProvider credentialsProvider, @Lazy BugTrackerFinderService bugTrackerFinderService) {
        this.dao = dao;
        this.projectManager = projectManager;
        this.credentialsProvider = credentialsProvider;
        this.bugTrackerFinderService = bugTrackerFinderService;
    }

    public ConfigurationPage getConfigurationPageData(Long projectId) {
        boolean hasGitLabBugTracker;
        GenericProject project = this.projectManager.findById(projectId.longValue());
        BugTracker bugTracker = project.getBugTracker();
        boolean hasBugTrackerBinding = bugTracker != null;
        boolean bl = hasGitLabBugTracker = hasBugTrackerBinding && bugTracker.getKind().equals("gitlab.bugtracker");
        if (!hasBugTrackerBinding || !hasGitLabBugTracker) {
            throw new BadBugTrackerConfigurationException();
        }
        List projectNames = project.getBugtrackerProjectNames();
        Optional<Credentials> credentials = this.getCredentials(bugTracker.getId());
        if (credentials.isPresent()) {
            return new ConfigurationPage().withProjectId(projectId).withLinkedProjectPaths(projectNames).withMappings(this.getConfiguredMappings(projectId)).withAvailableLabels(this.getAvailableLabels(bugTracker, projectNames)).withDisplayState(this.getDisplayState(projectId));
        }
        BugTrackerDto bugTrackerDto = BugTrackerDto.from((BugTracker)bugTracker);
        return new ConfigurationPage().withProjectId(projectId).withAuthenticationRequired(true).withBugTracker(bugTrackerDto).withDisplayState(this.getDisplayState(projectId));
    }

    public Map<String, ProjectMappings> getConfiguredMappings(Long projectId) {
        ConfigurationDao.PersistedConfiguration persistedConfiguration = this.dao.loadOrGetDefaultConfiguration(projectId);
        return this.getConfiguredMappings(persistedConfiguration);
    }

    public boolean getDisplayState(Long projectId) {
        ConfigurationDao.PersistedConfiguration persistedConfiguration = this.dao.loadOrGetDefaultConfiguration(projectId);
        return persistedConfiguration.isDisplayState();
    }

    public Map<String, ProjectMappings> getConfiguredMappings(ConfigurationDao.PersistedConfiguration persistedConfiguration) {
        return persistedConfiguration.getMappings().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.asIssueMappingsConfiguration((ConfigurationDao.Mappings)e.getValue())));
    }

    private ProjectMappings asIssueMappingsConfiguration(ConfigurationDao.Mappings value) {
        return new ProjectMappings(value.getPropertyScopes(), value.getPropertyLabels(), value.getStatusScopes(), value.getStatusLabels());
    }

    private Map<String, ConfigurationPage.AvailableLabels> getAvailableLabels(BugTracker bugTracker, List<String> projectPaths) {
        GitLabApiWrapper gitLabApi = this.createGitLabApiWrapper(bugTracker);
        try {
            Map<String, ConfigurationPage.AvailableLabels> map = projectPaths.stream().collect(Collectors.toMap(projectPath -> projectPath, projectPath -> this.findAvailableLabels(gitLabApi, (String)projectPath)));
            if (gitLabApi != null) {
                gitLabApi.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (gitLabApi != null) {
                    try {
                        gitLabApi.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (BugTrackerRemoteException ex) {
                throw new CannotReachGitLabServerException(bugTracker.getName());
            }
        }
    }

    private ConfigurationPage.AvailableLabels findAvailableLabels(GitLabApiWrapper gitLabApi, String projectPath) {
        HashSet scopes = new HashSet();
        HashSet labels = new HashSet();
        boolean projectIsAvailable = true;
        try {
            gitLabApi.getProjectLabels(projectPath).forEach(label -> {
                if (ScopedLabelHelper.isScopedLabel(label.getName())) {
                    scopes.add(ScopedLabelHelper.extractLabelScope(label.getName()));
                } else {
                    labels.add(label.getName());
                }
            });
        }
        catch (GitLabApiException ex) {
            projectIsAvailable = false;
        }
        return new ConfigurationPage.AvailableLabels(projectIsAvailable, scopes.stream().sorted().collect(Collectors.toList()), labels.stream().sorted().collect(Collectors.toList()));
    }

    private GitLabApiWrapper createGitLabApiWrapper(BugTracker bugTracker) {
        Credentials credentials = this.getCredentials(bugTracker.getId()).orElseThrow(() -> new CannotReachGitLabServerException(bugTracker.getName()));
        return new GitLabApiWrapper(bugTracker, credentials);
    }

    private Optional<Credentials> getCredentials(Long serverId) {
        BugTracker server = this.bugTrackerFinderService.findById(serverId.longValue());
        Optional appLevelCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)server);
        Optional userCredentials = this.credentialsProvider.getCurrentUserCredentials((ThirdPartyServer)server);
        AuthenticationPolicy policy = server.getAuthenticationPolicy();
        if (policy.equals((Object)AuthenticationPolicy.APP_LEVEL)) {
            return appLevelCredentials;
        }
        return appLevelCredentials.isPresent() ? appLevelCredentials : userCredentials;
    }

    public void setPriorityMappings(Long tmProjectId, String remoteProjectPath, List<String> scopes, List<String> labels) {
        try {
            ConfigurationDao.PersistedConfiguration configuration = this.dao.loadOrGetDefaultConfiguration(tmProjectId);
            Map<String, ConfigurationDao.Mappings> mappingsByProject = configuration.getMappings();
            labels = EmojiStringHelper.findAndEncodeStringsWithEmoji(labels);
            ConfigurationDao.Mappings updatedMappings = mappingsByProject.getOrDefault(remoteProjectPath, ConfigurationDao.Mappings.empty()).withPropertyLabels(labels).withPropertyScopes(scopes);
            mappingsByProject.put(remoteProjectPath, updatedMappings);
            this.dao.saveConfiguration(tmProjectId, new ConfigurationDao.PersistedConfiguration(mappingsByProject, true));
        }
        catch (IOException ex) {
            throw new BugTrackerLocalException(CONFIGURATION_ERROR_MESSAGE + tmProjectId, (Throwable)ex);
        }
    }

    public void setStatusMappings(Long tmProjectId, String remoteProjectPath, List<String> scopes, List<String> labels) {
        try {
            ConfigurationDao.PersistedConfiguration configuration = this.dao.loadOrGetDefaultConfiguration(tmProjectId);
            Map<String, ConfigurationDao.Mappings> mappingsByProject = configuration.getMappings();
            labels = EmojiStringHelper.findAndEncodeStringsWithEmoji(labels);
            ConfigurationDao.Mappings updatedMappings = mappingsByProject.getOrDefault(remoteProjectPath, ConfigurationDao.Mappings.empty()).withStatusLabels(labels).withStatusScopes(scopes);
            mappingsByProject.put(remoteProjectPath, updatedMappings);
            this.dao.saveConfiguration(tmProjectId, new ConfigurationDao.PersistedConfiguration(mappingsByProject, true));
        }
        catch (IOException ex) {
            throw new BugTrackerLocalException(CONFIGURATION_ERROR_MESSAGE + tmProjectId, (Throwable)ex);
        }
    }

    public void removeProjectMappings(Long tmProjectId, String remoteProjectPath) {
        try {
            ConfigurationDao.PersistedConfiguration configuration = this.dao.loadOrGetDefaultConfiguration(tmProjectId);
            configuration.getMappings().remove(remoteProjectPath);
            this.dao.saveConfiguration(tmProjectId, new ConfigurationDao.PersistedConfiguration(configuration.getMappings(), true));
        }
        catch (IOException ex) {
            throw new BugTrackerLocalException(CONFIGURATION_ERROR_MESSAGE + tmProjectId, (Throwable)ex);
        }
    }

    public boolean hasConfiguration(EntityReference entityReference) {
        return EntityType.PROJECT.equals((Object)entityReference.getType()) && !this.getConfiguredMappings(entityReference.getId()).isEmpty();
    }

    public void updateDisplayState(long projectId, boolean newValue) {
        this.dao.updateDisplayState(projectId, newValue);
    }
}

