/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.domain;

import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.models.Project;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.bugtracker.advanceddomain.Rendering;
import org.squashtest.tm.plugin.bugtracker.gitlab.client.GitLabApiWrapper;

@Component(value="squash.tm.plugin.bugtracker.gitlab.ShallowSchemeBuilder")
public class ShallowSchemeBuilder {
    protected final MessageSource messageSource;
    public static final String DEFAULT_SCHEME = "default";

    public ShallowSchemeBuilder(@Named(value="gitlabConnectorMessageSource") MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public Map<String, List<Field>> buildSchemes(Project project, GitLabApiWrapper gitLabApi) {
        List<Field> fields = Stream.of(this.buildTitleField(), GitLabApiWrapper.withGitLabExceptionWrapping(() -> this.buildDescriptionTemplateField(project, gitLabApi)), this.buildDescriptionField(), GitLabApiWrapper.withGitLabExceptionWrapping(() -> this.buildLabelsField(project, gitLabApi)), GitLabApiWrapper.withGitLabExceptionWrapping(() -> this.buildAssigneesField(project, gitLabApi)), GitLabApiWrapper.withGitLabExceptionWrapping(() -> this.buildMilestoneField(project, gitLabApi)), GitLabApiWrapper.withGitLabExceptionWrapping(this::buildConfidentialField), this.buildDueDateField(), this.buildLinkedIssueFieldIfSupported(project), this.buildLinkedIssuesField(project), GitLabApiWrapper.withGitLabExceptionWrapping(() -> this.buildEpicField(project, gitLabApi)), this.buildAttachmentsField()).filter(Objects::nonNull).toList();
        return Collections.singletonMap(DEFAULT_SCHEME, fields);
    }

    protected Field buildDescriptionField() {
        return this.buildBasicField("description", InputType.TypeName.TEXT_AREA.value);
    }

    protected Field buildTitleField() {
        return this.buildBasicRequiredField("summary", InputType.TypeName.TEXT_FIELD.value);
    }

    protected Field buildLabelsField(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        return this.buildBasicField("labels", InputType.TypeName.TAG_LIST.value);
    }

    protected Field buildMappedPriorityLabelsField() {
        return this.buildBasicField("priority", InputType.TypeName.TAG_LIST.value);
    }

    protected Field buildMappedStatusLabelsField() {
        return this.buildBasicField("status", InputType.TypeName.TAG_LIST.value);
    }

    protected Field buildAssigneesField(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        return this.buildBasicField("assignees", InputType.TypeName.TEXT_FIELD.value);
    }

    protected Field buildMilestoneField(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        return this.buildBasicField("milestone", InputType.TypeName.DROPDOWN_LIST.value);
    }

    protected Field buildConfidentialField() {
        return this.buildBasicField("confidential", InputType.TypeName.CHECKBOX.value);
    }

    protected Field buildAttachmentsField() {
        return this.buildBasicField("attachments", InputType.TypeName.FILE_UPLOAD.value);
    }

    protected Field buildDueDateField() {
        return this.buildBasicField("dueDate", InputType.TypeName.DATE_PICKER.value, "due-date");
    }

    protected Field buildLinkedIssueFieldIfSupported(Project project) {
        return null;
    }

    protected Field buildEpicField(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        return this.buildBasicField("epic", InputType.TypeName.DROPDOWN_LIST.value);
    }

    protected Field buildLinkedIssuesField(Project project) {
        return this.buildBasicField("linkedIssues", InputType.TypeName.FREE_TAG_LIST.value, "linked-issues");
    }

    protected Field buildDescriptionTemplateField(Project project, GitLabApiWrapper gitLabApi) throws GitLabApiException {
        return this.buildBasicField("descriptionTemplate", InputType.TypeName.DROPDOWN_LIST.value, "description-template");
    }

    protected Field buildBasicField(String fieldId, String fieldType) {
        return this.buildBasicField(fieldId, fieldType, fieldId);
    }

    protected Field buildBasicField(String fieldId, String fieldType, String localeKeyPart) {
        Field field = new Field();
        field.setId(fieldId);
        String i18nKey = "interface.report." + localeKeyPart + ".label";
        field.setLabel(this.messageSource.getMessage(i18nKey, null, LocaleContextHolder.getLocale()));
        Rendering rendering = new Rendering();
        rendering.setInputType(new InputType(fieldType, InputType.TypeName.UNKNOWN.value));
        field.setRendering(rendering);
        return field;
    }

    protected Field buildBasicRequiredField(String fieldId, String fieldType) {
        Field field = this.buildBasicField(fieldId, fieldType);
        field.getRendering().setRequired(true);
        return field;
    }
}

