/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api.utils;

import gitlabbt.jakarta.ws.rs.core.Response;
import gitlabbt.org.gitlab4j.api.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.Base64;
import java.util.Scanner;

public class FileUtils {
    public static File createUniqueFile(File directory, String filename) throws IOException {
        File uniqueFile = new File(directory, filename);
        if (uniqueFile.createNewFile()) {
            return uniqueFile;
        }
        String extension = "";
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex >= 0) {
            extension = filename.substring(dotIndex);
            filename = filename.substring(0, dotIndex);
        }
        int fileNumber = 0;
        while (!uniqueFile.createNewFile()) {
            String numberedFilename = String.format("%s-%d%s", filename, ++fileNumber, extension);
            uniqueFile = new File(directory, numberedFilename);
        }
        return uniqueFile;
    }

    public static String getFilenameFromContentDisposition(Response response) {
        String disposition = response.getHeaderString("Content-Disposition");
        if (disposition == null || disposition.trim().length() == 0) {
            return null;
        }
        return disposition.replaceFirst("(?i)^.*filename=\"([^\"]+)\".*$", "$1");
    }

    public static String readFileContents(File file) throws IOException {
        try (Scanner in = new Scanner(file);){
            in.useDelimiter("\\Z");
            String string = in.next();
            return string;
        }
    }

    public static String getReaderContentAsString(Reader reader) throws IOException {
        int count;
        char[] buffer = new char[2048];
        StringBuilder out = new StringBuilder();
        while ((count = reader.read(buffer, 0, buffer.length)) >= 0) {
            out.append(buffer, 0, count);
        }
        return out.toString();
    }

    public static String getFileContentAsString(File file, Constants.Encoding encoding) throws IOException {
        if (encoding == Constants.Encoding.BASE64) {
            try (FileInputStream stream = new FileInputStream(file);){
                byte[] data = new byte[(int)file.length()];
                stream.read(data);
                String string = Base64.getEncoder().encodeToString(data);
                return string;
            }
        }
        return new String(Files.readAllBytes(file.toPath()));
    }
}

