/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.jakarta.ws.rs.core.Response;
import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.models.NotificationSettings;

public class NotificationSettingsApi
extends AbstractApi {
    public NotificationSettingsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public NotificationSettings getGlobalNotificationSettings() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "notification_settings");
        return response.readEntity(NotificationSettings.class);
    }

    public NotificationSettings updateGlobalNotificationSettings(NotificationSettings settings) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("level", (Object)settings.getLevel()).withParam("email", settings.getEmail());
        NotificationSettings.Events events = settings.getEvents();
        if (events != null) {
            formData.withParam("new_note", events.getNewNote()).withParam("new_issue", events.getNewIssue()).withParam("reopen_issue", events.getReopenIssue()).withParam("close_issue", events.getCloseIssue()).withParam("reassign_issue", events.getReassignIssue()).withParam("new_merge_request", events.getNewMergeRequest()).withParam("reopen_merge_request", events.getReopenMergeRequest()).withParam("close_merge_request", events.getCloseMergeRequest()).withParam("reassign_merge_request", events.getReassignMergeRequest()).withParam("merge_merge_request", events.getMergeMergeRequest()).withParam("failed_pipeline", events.getFailedPipeline()).withParam("success_pipeline", events.getSuccessPipeline());
        }
        Response response = this.put(Response.Status.OK, formData.asMap(), "notification_settings");
        return response.readEntity(NotificationSettings.class);
    }

    public NotificationSettings getGroupNotificationSettings(int groupId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", groupId, "notification_settings");
        return response.readEntity(NotificationSettings.class);
    }

    public NotificationSettings updateGroupNotificationSettings(int groupId, NotificationSettings settings) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("level", (Object)settings.getLevel()).withParam("email", settings.getEmail());
        NotificationSettings.Events events = settings.getEvents();
        if (events != null) {
            formData.withParam("new_note", events.getNewNote()).withParam("new_issue", events.getNewIssue()).withParam("reopen_issue", events.getReopenIssue()).withParam("close_issue", events.getCloseIssue()).withParam("reassign_issue", events.getReassignIssue()).withParam("new_merge_request", events.getNewMergeRequest()).withParam("reopen_merge_request", events.getReopenMergeRequest()).withParam("close_merge_request", events.getCloseMergeRequest()).withParam("reassign_merge_request", events.getReassignMergeRequest()).withParam("merge_merge_request", events.getMergeMergeRequest()).withParam("failed_pipeline", events.getFailedPipeline()).withParam("success_pipeline", events.getSuccessPipeline());
        }
        Response response = this.put(Response.Status.OK, formData.asMap(), "groups", groupId, "notification_settings");
        return response.readEntity(NotificationSettings.class);
    }

    public NotificationSettings getProjectNotificationSettings(int projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "notification_settings");
        return response.readEntity(NotificationSettings.class);
    }

    public NotificationSettings updateProjectNotificationSettings(int projectId, NotificationSettings settings) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("level", (Object)settings.getLevel()).withParam("email", settings.getEmail());
        NotificationSettings.Events events = settings.getEvents();
        if (events != null) {
            formData.withParam("new_note", events.getNewNote()).withParam("new_issue", events.getNewIssue()).withParam("reopen_issue", events.getReopenIssue()).withParam("close_issue", events.getCloseIssue()).withParam("reassign_issue", events.getReassignIssue()).withParam("new_merge_request", events.getNewMergeRequest()).withParam("reopen_merge_request", events.getReopenMergeRequest()).withParam("close_merge_request", events.getCloseMergeRequest()).withParam("reassign_merge_request", events.getReassignMergeRequest()).withParam("merge_merge_request", events.getMergeMergeRequest()).withParam("failed_pipeline", events.getFailedPipeline()).withParam("success_pipeline", events.getSuccessPipeline());
        }
        Response response = this.put(Response.Status.OK, formData.asMap(), "projects", projectId, "notification_settings");
        return response.readEntity(NotificationSettings.class);
    }
}

