/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.jakarta.ws.rs.core.Response;
import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.ApplicationSettingsApi;
import gitlabbt.org.gitlab4j.api.ApplicationsApi;
import gitlabbt.org.gitlab4j.api.AuditEventApi;
import gitlabbt.org.gitlab4j.api.AwardEmojiApi;
import gitlabbt.org.gitlab4j.api.BoardsApi;
import gitlabbt.org.gitlab4j.api.CommitsApi;
import gitlabbt.org.gitlab4j.api.Constants;
import gitlabbt.org.gitlab4j.api.ContainerRegistryApi;
import gitlabbt.org.gitlab4j.api.DeployKeysApi;
import gitlabbt.org.gitlab4j.api.DeployTokensApi;
import gitlabbt.org.gitlab4j.api.DeploymentsApi;
import gitlabbt.org.gitlab4j.api.DiscussionsApi;
import gitlabbt.org.gitlab4j.api.EnvironmentsApi;
import gitlabbt.org.gitlab4j.api.EpicsApi;
import gitlabbt.org.gitlab4j.api.EventsApi;
import gitlabbt.org.gitlab4j.api.GitLabApiClient;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GroupApi;
import gitlabbt.org.gitlab4j.api.HealthCheckApi;
import gitlabbt.org.gitlab4j.api.ImportExportApi;
import gitlabbt.org.gitlab4j.api.IssuesApi;
import gitlabbt.org.gitlab4j.api.JobApi;
import gitlabbt.org.gitlab4j.api.LabelsApi;
import gitlabbt.org.gitlab4j.api.LicenseApi;
import gitlabbt.org.gitlab4j.api.LicenseTemplatesApi;
import gitlabbt.org.gitlab4j.api.MarkdownApi;
import gitlabbt.org.gitlab4j.api.MergeRequestApi;
import gitlabbt.org.gitlab4j.api.MilestonesApi;
import gitlabbt.org.gitlab4j.api.NamespaceApi;
import gitlabbt.org.gitlab4j.api.NotesApi;
import gitlabbt.org.gitlab4j.api.NotificationSettingsApi;
import gitlabbt.org.gitlab4j.api.PackagesApi;
import gitlabbt.org.gitlab4j.api.PipelineApi;
import gitlabbt.org.gitlab4j.api.ProjectApi;
import gitlabbt.org.gitlab4j.api.ProtectedBranchesApi;
import gitlabbt.org.gitlab4j.api.ReleasesApi;
import gitlabbt.org.gitlab4j.api.RepositoryApi;
import gitlabbt.org.gitlab4j.api.RepositoryFileApi;
import gitlabbt.org.gitlab4j.api.ResourceLabelEventsApi;
import gitlabbt.org.gitlab4j.api.ResourceStateEventsApi;
import gitlabbt.org.gitlab4j.api.RunnersApi;
import gitlabbt.org.gitlab4j.api.SearchApi;
import gitlabbt.org.gitlab4j.api.ServicesApi;
import gitlabbt.org.gitlab4j.api.SnippetsApi;
import gitlabbt.org.gitlab4j.api.SystemHooksApi;
import gitlabbt.org.gitlab4j.api.TagsApi;
import gitlabbt.org.gitlab4j.api.TodosApi;
import gitlabbt.org.gitlab4j.api.UserApi;
import gitlabbt.org.gitlab4j.api.WikisApi;
import gitlabbt.org.gitlab4j.api.models.OauthTokenResponse;
import gitlabbt.org.gitlab4j.api.models.User;
import gitlabbt.org.gitlab4j.api.models.Version;
import gitlabbt.org.gitlab4j.api.utils.MaskingLoggingFilter;
import gitlabbt.org.gitlab4j.api.utils.Oauth2LoginStreamingOutput;
import gitlabbt.org.gitlab4j.api.utils.SecretString;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GitLabApi
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(GitLabApi.class.getName());
    public static final int DEFAULT_PER_PAGE = 96;
    private static final Map<Integer, GitLabApiException> optionalExceptionMap = Collections.synchronizedMap(new WeakHashMap());
    GitLabApiClient apiClient;
    private ApiVersion apiVersion;
    private String gitLabServerUrl;
    private Map<String, Object> clientConfigProperties;
    private int defaultPerPage = 96;
    private ApplicationsApi applicationsApi;
    private ApplicationSettingsApi applicationSettingsApi;
    private AuditEventApi auditEventApi;
    private AwardEmojiApi awardEmojiApi;
    private BoardsApi boardsApi;
    private CommitsApi commitsApi;
    private ContainerRegistryApi containerRegistryApi;
    private DiscussionsApi discussionsApi;
    private DeployKeysApi deployKeysApi;
    private DeploymentsApi deploymentsApi;
    private DeployTokensApi deployTokensApi;
    private EnvironmentsApi environmentsApi;
    private EpicsApi epicsApi;
    private EventsApi eventsApi;
    private GroupApi groupApi;
    private HealthCheckApi healthCheckApi;
    private ImportExportApi importExportApi;
    private IssuesApi issuesApi;
    private JobApi jobApi;
    private LabelsApi labelsApi;
    private LicenseApi licenseApi;
    private LicenseTemplatesApi licenseTemplatesApi;
    private MarkdownApi markdownApi;
    private MergeRequestApi mergeRequestApi;
    private MilestonesApi milestonesApi;
    private NamespaceApi namespaceApi;
    private NotesApi notesApi;
    private NotificationSettingsApi notificationSettingsApi;
    private PackagesApi packagesApi;
    private PipelineApi pipelineApi;
    private ProjectApi projectApi;
    private ProtectedBranchesApi protectedBranchesApi;
    private ReleasesApi releasesApi;
    private RepositoryApi repositoryApi;
    private RepositoryFileApi repositoryFileApi;
    private ResourceLabelEventsApi resourceLabelEventsApi;
    private ResourceStateEventsApi resourceStateEventsApi;
    private RunnersApi runnersApi;
    private SearchApi searchApi;
    private ServicesApi servicesApi;
    private SnippetsApi snippetsApi;
    private SystemHooksApi systemHooksApi;
    private TagsApi tagsApi;
    private TodosApi todosApi;
    private UserApi userApi;
    private WikisApi wikisApi;

    public static final Logger getLogger() {
        return LOGGER;
    }

    public GitLabApi(String hostUrl, String personalAccessToken) {
        this(ApiVersion.V4, hostUrl, personalAccessToken, null);
    }

    public GitLabApi(String hostUrl, String personalAccessToken, String secretToken) {
        this(ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, personalAccessToken, secretToken);
    }

    public static GitLabApi oauth2Login(String url, String username, CharSequence password) throws GitLabApiException {
        return GitLabApi.oauth2Login(ApiVersion.V4, url, username, password, null, null, false);
    }

    public static GitLabApi oauth2Login(String url, String username, char[] password) throws GitLabApiException {
        try (SecretString secretPassword = new SecretString(password);){
            GitLabApi gitLabApi = GitLabApi.oauth2Login(ApiVersion.V4, url, username, secretPassword, null, null, false);
            return gitLabApi;
        }
    }

    public static GitLabApi oauth2Login(String url, String username, CharSequence password, boolean ignoreCertificateErrors) throws GitLabApiException {
        return GitLabApi.oauth2Login(ApiVersion.V4, url, username, password, null, null, ignoreCertificateErrors);
    }

    public static GitLabApi oauth2Login(String url, String username, char[] password, boolean ignoreCertificateErrors) throws GitLabApiException {
        try (SecretString secretPassword = new SecretString(password);){
            GitLabApi gitLabApi = GitLabApi.oauth2Login(ApiVersion.V4, url, username, secretPassword, null, null, ignoreCertificateErrors);
            return gitLabApi;
        }
    }

    public static GitLabApi oauth2Login(String url, String username, CharSequence password, String secretToken, Map<String, Object> clientConfigProperties, boolean ignoreCertificateErrors) throws GitLabApiException {
        return GitLabApi.oauth2Login(ApiVersion.V4, url, username, password, secretToken, clientConfigProperties, ignoreCertificateErrors);
    }

    public static GitLabApi oauth2Login(String url, String username, char[] password, String secretToken, Map<String, Object> clientConfigProperties, boolean ignoreCertificateErrors) throws GitLabApiException {
        try (SecretString secretPassword = new SecretString(password);){
            GitLabApi gitLabApi = GitLabApi.oauth2Login(ApiVersion.V4, url, username, secretPassword, secretToken, clientConfigProperties, ignoreCertificateErrors);
            return gitLabApi;
        }
    }

    public static GitLabApi oauth2Login(ApiVersion apiVersion, String url, String username, char[] password, String secretToken, Map<String, Object> clientConfigProperties, boolean ignoreCertificateErrors) throws GitLabApiException {
        try (SecretString secretPassword = new SecretString(password);){
            GitLabApi gitLabApi = GitLabApi.oauth2Login(apiVersion, url, username, secretPassword, secretToken, clientConfigProperties, ignoreCertificateErrors);
            return gitLabApi;
        }
    }

    public static GitLabApi oauth2Login(ApiVersion apiVersion, String url, String username, CharSequence password, String secretToken, Map<String, Object> clientConfigProperties, boolean ignoreCertificateErrors) throws GitLabApiException {
        if (username == null || username.trim().length() == 0) {
            throw new IllegalArgumentException("both username and email cannot be empty or null");
        }
        GitLabApi gitLabApi = new GitLabApi(apiVersion, url, (String)null);
        gitLabApi.apiClient.setHostUrlToBaseUrl();
        if (ignoreCertificateErrors) {
            gitLabApi.setIgnoreCertificateErrors(true);
        }
        try (Oauth2LoginStreamingOutput stream = new Oauth2LoginStreamingOutput(username, password);){
            class Oauth2Api
            extends AbstractApi {
                Oauth2Api(GitLabApi gitlabApi) {
                    super(gitlabApi);
                }
            }
            Response response = new Oauth2Api(gitLabApi).post(Response.Status.OK, stream, "application/json", "oauth", "token");
            OauthTokenResponse oauthToken = response.readEntity(OauthTokenResponse.class);
            gitLabApi = new GitLabApi(apiVersion, url, Constants.TokenType.OAUTH2_ACCESS, oauthToken.getAccessToken(), secretToken, clientConfigProperties);
            if (ignoreCertificateErrors) {
                gitLabApi.setIgnoreCertificateErrors(true);
            }
            GitLabApi gitLabApi2 = gitLabApi;
            return gitLabApi2;
        }
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String personalAccessToken) {
        this(apiVersion, hostUrl, personalAccessToken, null);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String personalAccessToken, String secretToken) {
        this(apiVersion, hostUrl, personalAccessToken, secretToken, null);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken) {
        this(apiVersion, hostUrl, tokenType, authToken, null);
    }

    public GitLabApi(String hostUrl, Constants.TokenType tokenType, String authToken) {
        this(ApiVersion.V4, hostUrl, tokenType, authToken, null);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken) {
        this(apiVersion, hostUrl, tokenType, authToken, secretToken, null);
    }

    public GitLabApi(String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken) {
        this(ApiVersion.V4, hostUrl, tokenType, authToken, secretToken);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String personalAccessToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(apiVersion, hostUrl, Constants.TokenType.PRIVATE, personalAccessToken, secretToken, clientConfigProperties);
    }

    public GitLabApi(String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(ApiVersion.V4, hostUrl, tokenType, authToken, secretToken, clientConfigProperties);
    }

    public GitLabApi(String hostUrl, String personalAccessToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, personalAccessToken, secretToken, clientConfigProperties);
    }

    public GitLabApi(String hostUrl, String personalAccessToken, Map<String, Object> clientConfigProperties) {
        this(ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, personalAccessToken, null, clientConfigProperties);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this.apiVersion = apiVersion;
        this.gitLabServerUrl = hostUrl;
        this.clientConfigProperties = clientConfigProperties;
        this.apiClient = new GitLabApiClient(apiVersion, hostUrl, tokenType, authToken, secretToken, clientConfigProperties);
    }

    public final GitLabApi duplicate() {
        Integer sudoUserId = this.getSudoAsId();
        GitLabApi gitLabApi = new GitLabApi(this.apiVersion, this.gitLabServerUrl, this.getTokenType(), this.getAuthToken(), this.getSecretToken(), this.clientConfigProperties);
        if (sudoUserId != null) {
            gitLabApi.apiClient.setSudoAsId(sudoUserId);
        }
        if (this.getIgnoreCertificateErrors()) {
            gitLabApi.setIgnoreCertificateErrors(true);
        }
        gitLabApi.defaultPerPage = this.defaultPerPage;
        return gitLabApi;
    }

    @Override
    public void close() {
        if (this.apiClient != null) {
            this.apiClient.close();
        }
    }

    public void setRequestTimeout(Integer connectTimeout, Integer readTimeout) {
        this.apiClient.setRequestTimeout(connectTimeout, readTimeout);
    }

    public GitLabApi withRequestTimeout(Integer connectTimeout, Integer readTimeout) {
        this.apiClient.setRequestTimeout(connectTimeout, readTimeout);
        return this;
    }

    public GitLabApi withRequestResponseLogging() {
        this.enableRequestResponseLogging();
        return this;
    }

    public GitLabApi withRequestResponseLogging(Level level) {
        this.enableRequestResponseLogging(level);
        return this;
    }

    public GitLabApi withRequestResponseLogging(Logger logger, Level level) {
        this.enableRequestResponseLogging(logger, level);
        return this;
    }

    public void enableRequestResponseLogging() {
        this.enableRequestResponseLogging(LOGGER, Level.FINE);
    }

    public void enableRequestResponseLogging(Level level) {
        this.enableRequestResponseLogging(LOGGER, level, 0);
    }

    public void enableRequestResponseLogging(Logger logger, Level level) {
        this.enableRequestResponseLogging(logger, level, 0);
    }

    public void enableRequestResponseLogging(Level level, int maxEntitySize) {
        this.enableRequestResponseLogging(LOGGER, level, maxEntitySize);
    }

    public void enableRequestResponseLogging(Logger logger, Level level, int maxEntitySize) {
        this.enableRequestResponseLogging(logger, level, maxEntitySize, MaskingLoggingFilter.DEFAULT_MASKED_HEADER_NAMES);
    }

    public void enableRequestResponseLogging(Level level, List<String> maskedHeaderNames) {
        this.apiClient.enableRequestResponseLogging(LOGGER, level, 0, maskedHeaderNames);
    }

    public void enableRequestResponseLogging(Logger logger, Level level, List<String> maskedHeaderNames) {
        this.apiClient.enableRequestResponseLogging(logger, level, 0, maskedHeaderNames);
    }

    public void enableRequestResponseLogging(Level level, int maxEntitySize, List<String> maskedHeaderNames) {
        this.apiClient.enableRequestResponseLogging(LOGGER, level, maxEntitySize, maskedHeaderNames);
    }

    public void enableRequestResponseLogging(Logger logger, Level level, int maxEntitySize, List<String> maskedHeaderNames) {
        this.apiClient.enableRequestResponseLogging(logger, level, maxEntitySize, maskedHeaderNames);
    }

    public void sudo(String sudoAsUsername) throws GitLabApiException {
        if (sudoAsUsername == null || sudoAsUsername.trim().length() == 0) {
            this.apiClient.setSudoAsId(null);
            return;
        }
        User user = this.getUserApi().getUser(sudoAsUsername);
        if (user == null || user.getId() == null) {
            throw new GitLabApiException("the specified username was not found");
        }
        Integer sudoAsId = user.getId();
        this.apiClient.setSudoAsId(sudoAsId);
    }

    public void unsudo() {
        this.apiClient.setSudoAsId(null);
    }

    public void setSudoAsId(Integer sudoAsId) throws GitLabApiException {
        if (sudoAsId == null) {
            this.apiClient.setSudoAsId(null);
            return;
        }
        User user = this.getUserApi().getUser(sudoAsId);
        if (user == null || !user.getId().equals(sudoAsId)) {
            throw new GitLabApiException("the specified user ID was not found");
        }
        this.apiClient.setSudoAsId(sudoAsId);
    }

    public Integer getSudoAsId() {
        return this.apiClient.getSudoAsId();
    }

    public String getAuthToken() {
        return this.apiClient.getAuthToken();
    }

    public String getSecretToken() {
        return this.apiClient.getSecretToken();
    }

    public Constants.TokenType getTokenType() {
        return this.apiClient.getTokenType();
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public String getGitLabServerUrl() {
        return this.gitLabServerUrl;
    }

    public int getDefaultPerPage() {
        return this.defaultPerPage;
    }

    public void setDefaultPerPage(int defaultPerPage) {
        this.defaultPerPage = defaultPerPage;
    }

    GitLabApiClient getApiClient() {
        return this.apiClient;
    }

    public boolean getIgnoreCertificateErrors() {
        return this.apiClient.getIgnoreCertificateErrors();
    }

    public void setIgnoreCertificateErrors(boolean ignoreCertificateErrors) {
        this.apiClient.setIgnoreCertificateErrors(ignoreCertificateErrors);
    }

    public Version getVersion() throws GitLabApiException {
        class VersionApi
        extends AbstractApi {
            VersionApi(GitLabApi gitlabApi) {
                super(gitlabApi);
            }
        }
        Response response = new VersionApi(this).get(Response.Status.OK, null, "version");
        return response.readEntity(Version.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationsApi getApplicationsApi() {
        if (this.applicationsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.applicationsApi == null) {
                    this.applicationsApi = new ApplicationsApi(this);
                }
            }
        }
        return this.applicationsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationSettingsApi getApplicationSettingsApi() {
        if (this.applicationSettingsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.applicationSettingsApi == null) {
                    this.applicationSettingsApi = new ApplicationSettingsApi(this);
                }
            }
        }
        return this.applicationSettingsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditEventApi getAuditEventApi() {
        if (this.auditEventApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.auditEventApi == null) {
                    this.auditEventApi = new AuditEventApi(this);
                }
            }
        }
        return this.auditEventApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AwardEmojiApi getAwardEmojiApi() {
        if (this.awardEmojiApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.awardEmojiApi == null) {
                    this.awardEmojiApi = new AwardEmojiApi(this);
                }
            }
        }
        return this.awardEmojiApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoardsApi getBoardsApi() {
        if (this.boardsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.boardsApi == null) {
                    this.boardsApi = new BoardsApi(this);
                }
            }
        }
        return this.boardsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitsApi getCommitsApi() {
        if (this.commitsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.commitsApi == null) {
                    this.commitsApi = new CommitsApi(this);
                }
            }
        }
        return this.commitsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerRegistryApi getContainerRegistryApi() {
        if (this.containerRegistryApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.containerRegistryApi == null) {
                    this.containerRegistryApi = new ContainerRegistryApi(this);
                }
            }
        }
        return this.containerRegistryApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployKeysApi getDeployKeysApi() {
        if (this.deployKeysApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.deployKeysApi == null) {
                    this.deployKeysApi = new DeployKeysApi(this);
                }
            }
        }
        return this.deployKeysApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentsApi getDeploymentsApi() {
        if (this.deploymentsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.deploymentsApi == null) {
                    this.deploymentsApi = new DeploymentsApi(this);
                }
            }
        }
        return this.deploymentsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployTokensApi getDeployTokensApi() {
        if (this.deployTokensApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.deployTokensApi == null) {
                    this.deployTokensApi = new DeployTokensApi(this);
                }
            }
        }
        return this.deployTokensApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscussionsApi getDiscussionsApi() {
        if (this.discussionsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.discussionsApi == null) {
                    this.discussionsApi = new DiscussionsApi(this);
                }
            }
        }
        return this.discussionsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvironmentsApi getEnvironmentsApi() {
        if (this.environmentsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.environmentsApi == null) {
                    this.environmentsApi = new EnvironmentsApi(this);
                }
            }
        }
        return this.environmentsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EpicsApi getEpicsApi() {
        if (this.epicsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.epicsApi == null) {
                    this.epicsApi = new EpicsApi(this);
                }
            }
        }
        return this.epicsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventsApi getEventsApi() {
        if (this.eventsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.eventsApi == null) {
                    this.eventsApi = new EventsApi(this);
                }
            }
        }
        return this.eventsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupApi getGroupApi() {
        if (this.groupApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.groupApi == null) {
                    this.groupApi = new GroupApi(this);
                }
            }
        }
        return this.groupApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthCheckApi getHealthCheckApi() {
        if (this.healthCheckApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.healthCheckApi == null) {
                    this.healthCheckApi = new HealthCheckApi(this);
                }
            }
        }
        return this.healthCheckApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportExportApi getImportExportApi() {
        if (this.importExportApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.importExportApi == null) {
                    this.importExportApi = new ImportExportApi(this);
                }
            }
        }
        return this.importExportApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IssuesApi getIssuesApi() {
        if (this.issuesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.issuesApi == null) {
                    this.issuesApi = new IssuesApi(this);
                }
            }
        }
        return this.issuesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobApi getJobApi() {
        if (this.jobApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.jobApi == null) {
                    this.jobApi = new JobApi(this);
                }
            }
        }
        return this.jobApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LabelsApi getLabelsApi() {
        if (this.labelsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.labelsApi == null) {
                    this.labelsApi = new LabelsApi(this);
                }
            }
        }
        return this.labelsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseApi getLicenseApi() {
        if (this.licenseApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.licenseApi == null) {
                    this.licenseApi = new LicenseApi(this);
                }
            }
        }
        return this.licenseApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseTemplatesApi getLicenseTemplatesApi() {
        if (this.licenseTemplatesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.licenseTemplatesApi == null) {
                    this.licenseTemplatesApi = new LicenseTemplatesApi(this);
                }
            }
        }
        return this.licenseTemplatesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarkdownApi getMarkdownApi() {
        if (this.markdownApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.markdownApi == null) {
                    this.markdownApi = new MarkdownApi(this);
                }
            }
        }
        return this.markdownApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeRequestApi getMergeRequestApi() {
        if (this.mergeRequestApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.mergeRequestApi == null) {
                    this.mergeRequestApi = new MergeRequestApi(this);
                }
            }
        }
        return this.mergeRequestApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MilestonesApi getMilestonesApi() {
        if (this.milestonesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.milestonesApi == null) {
                    this.milestonesApi = new MilestonesApi(this);
                }
            }
        }
        return this.milestonesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceApi getNamespaceApi() {
        if (this.namespaceApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.namespaceApi == null) {
                    this.namespaceApi = new NamespaceApi(this);
                }
            }
        }
        return this.namespaceApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotesApi getNotesApi() {
        if (this.notesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.notesApi == null) {
                    this.notesApi = new NotesApi(this);
                }
            }
        }
        return this.notesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationSettingsApi getNotificationSettingsApi() {
        if (this.notificationSettingsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.notificationSettingsApi == null) {
                    this.notificationSettingsApi = new NotificationSettingsApi(this);
                }
            }
        }
        return this.notificationSettingsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackagesApi getPackagesApi() {
        if (this.packagesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.packagesApi == null) {
                    this.packagesApi = new PackagesApi(this);
                }
            }
        }
        return this.packagesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipelineApi getPipelineApi() {
        if (this.pipelineApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.pipelineApi == null) {
                    this.pipelineApi = new PipelineApi(this);
                }
            }
        }
        return this.pipelineApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectApi getProjectApi() {
        if (this.projectApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.projectApi == null) {
                    this.projectApi = new ProjectApi(this);
                }
            }
        }
        return this.projectApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectedBranchesApi getProtectedBranchesApi() {
        if (this.protectedBranchesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.protectedBranchesApi == null) {
                    this.protectedBranchesApi = new ProtectedBranchesApi(this);
                }
            }
        }
        return this.protectedBranchesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReleasesApi getReleasesApi() {
        if (this.releasesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.releasesApi == null) {
                    this.releasesApi = new ReleasesApi(this);
                }
            }
        }
        return this.releasesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryApi getRepositoryApi() {
        if (this.repositoryApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.repositoryApi == null) {
                    this.repositoryApi = new RepositoryApi(this);
                }
            }
        }
        return this.repositoryApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryFileApi getRepositoryFileApi() {
        if (this.repositoryFileApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.repositoryFileApi == null) {
                    this.repositoryFileApi = new RepositoryFileApi(this);
                }
            }
        }
        return this.repositoryFileApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceLabelEventsApi getResourceLabelEventsApi() {
        if (this.resourceLabelEventsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.resourceLabelEventsApi == null) {
                    this.resourceLabelEventsApi = new ResourceLabelEventsApi(this);
                }
            }
        }
        return this.resourceLabelEventsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceStateEventsApi getResourceStateEventsApi() {
        if (this.resourceStateEventsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.resourceStateEventsApi == null) {
                    this.resourceStateEventsApi = new ResourceStateEventsApi(this);
                }
            }
        }
        return this.resourceStateEventsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunnersApi getRunnersApi() {
        if (this.runnersApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.runnersApi == null) {
                    this.runnersApi = new RunnersApi(this);
                }
            }
        }
        return this.runnersApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchApi getSearchApi() {
        if (this.searchApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.searchApi == null) {
                    this.searchApi = new SearchApi(this);
                }
            }
        }
        return this.searchApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServicesApi getServicesApi() {
        if (this.servicesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.servicesApi == null) {
                    this.servicesApi = new ServicesApi(this);
                }
            }
        }
        return this.servicesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemHooksApi getSystemHooksApi() {
        if (this.systemHooksApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.systemHooksApi == null) {
                    this.systemHooksApi = new SystemHooksApi(this);
                }
            }
        }
        return this.systemHooksApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagsApi getTagsApi() {
        if (this.tagsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.tagsApi == null) {
                    this.tagsApi = new TagsApi(this);
                }
            }
        }
        return this.tagsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnippetsApi getSnippetApi() {
        if (this.snippetsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.snippetsApi == null) {
                    this.snippetsApi = new SnippetsApi(this);
                }
            }
        }
        return this.snippetsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TodosApi getTodosApi() {
        if (this.todosApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.todosApi == null) {
                    this.todosApi = new TodosApi(this);
                }
            }
        }
        return this.todosApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserApi getUserApi() {
        if (this.userApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.userApi == null) {
                    this.userApi = new UserApi(this);
                }
            }
        }
        return this.userApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikisApi getWikisApi() {
        if (this.wikisApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.wikisApi == null) {
                    this.wikisApi = new WikisApi(this);
                }
            }
        }
        return this.wikisApi;
    }

    protected static final <T> Optional<T> createOptionalFromException(GitLabApiException glae) {
        Optional optional = Optional.empty();
        optionalExceptionMap.put(System.identityHashCode(optional), glae);
        return optional;
    }

    public static final GitLabApiException getOptionalException(Optional<?> optional) {
        return optionalExceptionMap.get(System.identityHashCode(optional));
    }

    public static final <T> T orElseThrow(Optional<T> optional) throws GitLabApiException {
        GitLabApiException glea = GitLabApi.getOptionalException(optional);
        if (glea != null) {
            throw glea;
        }
        return optional.get();
    }

    public static enum ApiVersion {
        V3,
        V4;


        public String getApiNamespace() {
            return "/api/" + this.name().toLowerCase();
        }
    }
}

