/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.jakarta.ws.rs.core.Form;
import gitlabbt.jakarta.ws.rs.core.Response;
import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.Environment;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class EnvironmentsApi
extends AbstractApi {
    public EnvironmentsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Environment> getEnvironments(Object projectIdOrPath) throws GitLabApiException {
        return this.getEnvironments(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Stream<Environment> getEnvironmentsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getEnvironments(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Pager<Environment> getEnvironments(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Environment>(this, Environment.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments");
    }

    public Environment getEnvironment(Object projectIdOrPath, Integer environmentId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId);
        return response.readEntity(Environment.class);
    }

    public Optional<Environment> getOptionalEnvironment(Object projectIdOrPath, Integer environmentId) {
        try {
            return Optional.ofNullable(this.getEnvironment(projectIdOrPath, environmentId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Environment createEnvironment(Object projectIdOrPath, String name, String externalUrl) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true).withParam("external_url", externalUrl);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments");
        return response.readEntity(Environment.class);
    }

    public Environment updateEnvironment(Object projectIdOrPath, Integer environmentId, String name, String externalUrl) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("external_url", externalUrl);
        Response response = this.putWithFormData(Response.Status.OK, formData, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId);
        return response.readEntity(Environment.class);
    }

    public Environment stopEnvironment(Object projectIdOrPath, Integer environmentId) throws GitLabApiException {
        Response response = this.post(Response.Status.OK, (Form)null, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId, "stop");
        return response.readEntity(Environment.class);
    }

    public void deleteEnvironment(Object projectIdOrPath, Integer environmentId) throws GitLabApiException {
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId);
    }

    public Environment createEnvironment(Object projectIdOrPath, Integer environmentId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm();
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "environments", environmentId, "stop");
        return response.readEntity(Environment.class);
    }
}

