/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.jakarta.ws.rs.core.Form;
import gitlabbt.jakarta.ws.rs.core.GenericType;
import gitlabbt.jakarta.ws.rs.core.Response;
import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.Board;
import gitlabbt.org.gitlab4j.api.models.BoardList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class BoardsApi
extends AbstractApi {
    public BoardsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Board> getBoards(Object projectIdOrPath) throws GitLabApiException {
        return this.getBoards(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Board> getBoards(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "boards");
        return response.readEntity(new GenericType<List<Board>>(){});
    }

    public Pager<Board> getBoards(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Board>(this, Board.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards");
    }

    public Stream<Board> getBoardsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getBoards(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Board getBoard(Object projectIdOrPath, Integer boardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId);
        return response.readEntity(Board.class);
    }

    public Optional<Board> getOptionalBoard(Object projectIdOrPath, Integer boardId) {
        try {
            return Optional.ofNullable(this.getBoard(projectIdOrPath, boardId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Board createBoard(Object projectIdOrPath, String name) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true);
        Response response = this.post(Response.Status.CREATED, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "boards");
        return response.readEntity(Board.class);
    }

    public BoardList updateBoard(Object projectIdOrPath, Integer boardId, String name, Integer assigneeId, Integer milestoneId, String labels, Integer weight) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("assignee_id", assigneeId).withParam("milestone_id", milestoneId).withParam("labels", labels).withParam("weight", weight);
        Response response = this.put(Response.Status.OK, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId);
        return response.readEntity(BoardList.class);
    }

    public void deleteBoard(Object projectIdOrPath, Integer boardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId);
    }

    public List<BoardList> getBoardLists(Object projectIdOrPath, Integer boardId) throws GitLabApiException {
        return this.getBoardLists(projectIdOrPath, boardId, this.getDefaultPerPage()).all();
    }

    public List<BoardList> getBoardLists(Object projectIdOrPath, Integer boardId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists");
        return response.readEntity(new GenericType<List<BoardList>>(){});
    }

    public Pager<BoardList> getBoardLists(Object projectIdOrPath, Integer boardId, int itemsPerPage) throws GitLabApiException {
        return new Pager<BoardList>(this, BoardList.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists");
    }

    public Stream<BoardList> getBoardsListsStream(Object projectIdOrPath, Integer boardId) throws GitLabApiException {
        return this.getBoardLists(projectIdOrPath, boardId, this.getDefaultPerPage()).stream();
    }

    public BoardList getBoardList(Object projectIdOrPath, Integer boardId, Integer listId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists", listId);
        return response.readEntity(BoardList.class);
    }

    public Optional<BoardList> getOptionalBoardList(Object projectIdOrPath, Integer boardId, Integer listId) {
        try {
            return Optional.ofNullable(this.getBoardList(projectIdOrPath, boardId, listId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public BoardList createBoardList(Object projectIdOrPath, Integer boardId, Integer labelId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("label_id", labelId, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists");
        return response.readEntity(BoardList.class);
    }

    public BoardList updateBoardList(Object projectIdOrPath, Integer boardId, Integer listId, Integer position) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("position", position, true);
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists", listId);
        return response.readEntity(BoardList.class);
    }

    public void deleteBoardList(Object projectIdOrPath, Integer boardId, Integer listId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists", listId);
    }
}

