/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.wizard.campaignassistant.internal.service.dto;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.wizard.campaignassistant.internal.service.dto.IterationReplicationCriteria;

public class AdvancedIterationReplicationCriteria
extends IterationReplicationCriteria {
    private List<RequirementCriticality> requirementCriticalities;
    private List<RequirementStatus> requirementStatuses;
    private List<Long> requirementCategories;
    private List<TestCaseStatus> testCaseStatuses;
    private List<TestCaseImportance> testCaseImportances;
    private List<Long> testCaseNatures;
    private List<Long> testCaseTypes;
    private List<ExecutionStatus> executionStatuses;
    private List<Long> executionUsers;
    private List<TestCaseExecutionMode> executionModes;
    private Date executionFromDate;
    private Date executionToDate;
    private List<Long> testSuites;
    private boolean keepIssued;
    private Map<String, List<String>> keepIssuedCriteria;
    private List<Long> itpiKeepIssued;
    private Long serverId;
    private boolean jiraServer;
    private boolean issuesAllExecs;

    public Long getServerId() {
        return this.serverId;
    }

    public void setServerId(Long serverId) {
        this.serverId = serverId;
    }

    public boolean isJiraServer() {
        return this.jiraServer;
    }

    public void setJiraServer(boolean jiraServer) {
        this.jiraServer = jiraServer;
    }

    public boolean isIssuesAllExecs() {
        return this.issuesAllExecs;
    }

    public void setIssuesAllExecs(boolean issuesAllExecs) {
        this.issuesAllExecs = issuesAllExecs;
    }

    public List<Long> getItpiKeepIssued() {
        return this.itpiKeepIssued;
    }

    public void setItpiKeepIssued(List<Long> itpiKeepIssued) {
        this.itpiKeepIssued = itpiKeepIssued;
    }

    public Map<String, List<String>> getKeepIssuedCriteria() {
        return this.keepIssuedCriteria;
    }

    public void setKeepIssuedCriteria(Map<String, List<String>> keepIssuedCriteria) {
        this.keepIssuedCriteria = keepIssuedCriteria;
    }

    public List<RequirementCriticality> getRequirementCriticalities() {
        return this.requirementCriticalities;
    }

    public void setRequirementCriticalities(List<RequirementCriticality> requirementCriticalities) {
        this.requirementCriticalities = requirementCriticalities;
    }

    public List<RequirementStatus> getRequirementStatuses() {
        return this.requirementStatuses;
    }

    public void setRequirementStatuses(List<RequirementStatus> requirementStatuses) {
        this.requirementStatuses = requirementStatuses;
    }

    public List<TestCaseStatus> getTestCaseStatuses() {
        return this.testCaseStatuses;
    }

    public void setTestCaseStatuses(List<TestCaseStatus> testCaseStatuses) {
        this.testCaseStatuses = testCaseStatuses;
    }

    public List<ExecutionStatus> getExecutionStatuses() {
        return this.executionStatuses;
    }

    public void setExecutionStatuses(List<ExecutionStatus> executionStatuses) {
        this.executionStatuses = executionStatuses;
    }

    public List<Long> getExecutionUsers() {
        return this.executionUsers;
    }

    public void setExecutionUsers(List<Long> executionUsers) {
        this.executionUsers = executionUsers;
    }

    public List<TestCaseExecutionMode> getExecutionModes() {
        return this.executionModes;
    }

    public void setExecutionModes(List<TestCaseExecutionMode> executionModes) {
        this.executionModes = executionModes;
    }

    public Date getExecutionFromDate() {
        return this.executionFromDate;
    }

    public void setExecutionFromDate(Date executionFromDate) {
        this.executionFromDate = executionFromDate;
    }

    public Date getExecutionToDate() {
        return this.executionToDate;
    }

    public void setExecutionToDate(Date executionToDate) {
        this.executionToDate = executionToDate;
    }

    public boolean isKeepIssued() {
        return this.keepIssued;
    }

    public void setKeepIssued(boolean keepIssued) {
        this.keepIssued = keepIssued;
    }

    public List<Long> getTestSuites() {
        return this.testSuites;
    }

    public void setTestSuites(List<Long> testSuites) {
        this.testSuites = testSuites;
    }

    public List<TestCaseImportance> getTestCaseImportances() {
        return this.testCaseImportances;
    }

    public void setTestCaseImportances(List<TestCaseImportance> testCaseImportances) {
        this.testCaseImportances = testCaseImportances;
    }

    public List<Long> getRequirementCategories() {
        return this.requirementCategories;
    }

    public void setRequirementCategories(List<Long> requirementCategories) {
        this.requirementCategories = requirementCategories;
    }

    public List<Long> getTestCaseNatures() {
        return this.testCaseNatures;
    }

    public void setTestCaseNatures(List<Long> testCaseNatures) {
        this.testCaseNatures = testCaseNatures;
    }

    public List<Long> getTestCaseTypes() {
        return this.testCaseTypes;
    }

    public void setTestCaseTypes(List<Long> testCaseTypes) {
        this.testCaseTypes = testCaseTypes;
    }

    @Override
    public boolean itpiComplies(IterationTestPlanItem itpi) {
        if (this.compliesExecCriteria(itpi)) {
            return true;
        }
        if (this.compliesIssueCriteria(itpi)) {
            return true;
        }
        if (this.compliesTestSuiteCriteria(itpi)) {
            return true;
        }
        if (this.compliesTCCriteria(itpi)) {
            return true;
        }
        return this.compliesReqCriteria(itpi);
    }

    private boolean compliesIssueCriteria(IterationTestPlanItem itpi) {
        if (!this.jiraServer) {
            return this.keepIssued && this.hasLastExecIssues(itpi);
        }
        return this.keepIssued && this.containsKeepIssued(itpi);
    }

    private boolean containsKeepIssued(IterationTestPlanItem itpi) {
        if (this.itpiKeepIssued == null) {
            return false;
        }
        Long itpiToTest = itpi.getId();
        for (Long itpiId : this.itpiKeepIssued) {
            if (!itpiId.equals(itpiToTest)) continue;
            return true;
        }
        return false;
    }

    private boolean compliesTestSuiteCriteria(IterationTestPlanItem itpi) {
        for (TestSuite ts : itpi.getTestSuites()) {
            if (!this.testSuites.contains(ts.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean compliesExecCriteria(IterationTestPlanItem itpi) {
        if (this.executionStatuses.contains(itpi.getExecutionStatus())) {
            return true;
        }
        if (itpi.getUser() != null && this.executionUsers.contains(itpi.getUser().getId())) {
            return true;
        }
        if ((this.executionFromDate != null || this.executionToDate != null) && this.before(this.executionFromDate, itpi.getLastExecutedOn()) && this.after(this.executionToDate, itpi.getLastExecutedOn())) {
            return true;
        }
        return this.executionModes.contains(itpi.getExecutionMode());
    }

    private boolean compliesTCCriteria(IterationTestPlanItem itpi) {
        if (itpi.getReferencedTestCase() != null) {
            if (this.testCaseStatuses.contains(itpi.getReferencedTestCase().getStatus())) {
                return true;
            }
            if (this.testCaseImportances.contains(itpi.getReferencedTestCase().getImportance())) {
                return true;
            }
            if (this.testCaseNatures.contains(itpi.getReferencedTestCase().getNature().getId())) {
                return true;
            }
            if (this.testCaseTypes.contains(itpi.getReferencedTestCase().getType().getId())) {
                return true;
            }
        }
        return false;
    }

    private boolean compliesReqCriteria(IterationTestPlanItem itpi) {
        if (itpi.getReferencedTestCase() != null) {
            for (RequirementVersion reqVer : itpi.getReferencedTestCase().getVerifiedRequirementVersions()) {
                if (this.requirementCriticalities.contains(reqVer.getCriticality())) {
                    return true;
                }
                if (this.requirementStatuses.contains(reqVer.getStatus())) {
                    return true;
                }
                if (!this.requirementCategories.contains(reqVer.getCategory().getId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean before(Date dateForm, Date dateItpi) {
        if (dateItpi == null) {
            return false;
        }
        if (dateForm == null) {
            return true;
        }
        return dateForm.before(dateItpi);
    }

    private boolean after(Date dateForm, Date dateItpi) {
        if (dateItpi == null) {
            return false;
        }
        if (dateForm == null) {
            return true;
        }
        return this.addOneDay(dateForm).after(dateItpi);
    }

    private Date addOneDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, 1);
        return cal.getTime();
    }
}

