/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.configuration;

import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.squashtest.tm.api.plugin.PluginType;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.plugin.workflow.automjira.configuration.JiraAutomationWorkflowPlugin;
import org.squashtest.tm.plugin.workflow.automjira.licensevalidator.LicenseValidator;
import org.squashtest.tm.plugin.workflow.automjira.licensevalidator.service.ValidationService;
import org.squashtest.tm.plugin.workflow.automjira.licensevalidator.service.impl.ValidationServiceImpl;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Configuration(value="squash.tm.plugin.automjira.conf")
@ComponentScan(basePackages={"org.squashtest.tm.plugin.workflow.automjira"})
public class SpringConfiguration {
    @Inject
    private InternationalizationHelper langHelper;

    @Bean(name={"henix.plugin.workflow.automjira"})
    public JiraAutomationWorkflowPlugin jiraAutomationWorkflow() {
        JiraAutomationWorkflowPlugin plugin = new JiraAutomationWorkflowPlugin();
        plugin.setMessageSource((MessageSource)this.langHelper);
        plugin.setNameKey("henix.plugin.automation.workflow.automjira");
        plugin.setTypeKey("henix.automjira.plugin.type");
        plugin.setPluginType(PluginType.AUTOMATION);
        plugin.setDisplayWorkspace(WorkspaceType.TEST_CASE_WORKSPACE);
        return plugin;
    }

    @Bean(name={"org.squashtest.tm.plugin.workflow.automjira.ValidationService"})
    public ValidationService validationService() {
        return new ValidationServiceImpl();
    }

    @Bean(name={"org.squashtest.tm.plugin.workflow.automjira.LicenseValidator"})
    public LicenseValidator licenseValidator(@Named(value="org.squashtest.tm.plugin.workflow.automjira.ValidationService") @Named(value="org.squashtest.tm.plugin.workflow.automjira.ValidationService") ValidationService service) {
        return new LicenseValidator(service);
    }
}

