/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.legacybooks.requirements.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.AttachReq;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.CufData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.CufPair;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.ReqLinkData;
import org.squashtest.tm.plugin.report.legacybooks.requirements.dto.TestCaseData;

public class RequirementVersionData {
    private Long parentFolderId;
    private Long parentReqVersionId;
    private Long projectId;
    private Long versionId;
    private Long requirementId;
    private String reference;
    private int versionNumber;
    private String criticality;
    private String status;
    private String category;
    private String categoryType;
    private int nbAttachments;
    private String name;
    private String description;
    private String createdBy;
    private Date createdOn;
    private String modifiedBy;
    private Date modifiedOn;
    private int totalVersionNumber;
    private String milestoneLabels;
    private List<TestCaseData> boundTestCases = new LinkedList<TestCaseData>();
    private List<CufPair> cufPairs = new ArrayList<CufPair>();
    private List<CufData> rtfCufs = new ArrayList<CufData>();
    private List<CufData> numCufs = new ArrayList<CufData>();
    private List<CufData> tagCufs = new ArrayList<CufData>();
    private List<ReqLinkData> reqLinks = new ArrayList<ReqLinkData>();
    private List<AttachReq> attachReqs;
    private List<RequirementVersionData> childrenRequirements = new LinkedList<RequirementVersionData>();
    private RequirementVersionData parentRequirementVersion;

    public List<CufData> getTagCufs() {
        return this.tagCufs;
    }

    public void setTagCufs(List<CufData> tagCufs) {
        this.tagCufs = tagCufs;
    }

    public Long getParentFolderId() {
        return this.parentFolderId;
    }

    public void setParentFolderId(Long parentFolderId) {
        this.parentFolderId = parentFolderId;
    }

    public Long getParentReqVersionId() {
        return this.parentReqVersionId;
    }

    public void setParentReqVersionId(Long parentReqVersionId) {
        this.parentReqVersionId = parentReqVersionId;
    }

    public RequirementVersionData getParentRequirementVersion() {
        return this.parentRequirementVersion;
    }

    public boolean hasParentRequirementVersion() {
        return this.parentReqVersionId != null;
    }

    public void setParentRequirementVersion(RequirementVersionData parentRequirementVersion) {
        this.parentRequirementVersion = parentRequirementVersion;
    }

    public void addChildrenRequirement(RequirementVersionData requirement) {
        this.childrenRequirements.add(requirement);
        requirement.setParentRequirementVersion(this);
    }

    public String getParentRequirementDisplayableName() {
        if (this.hasParentRequirementVersion()) {
            RequirementVersionData parent = this.parentRequirementVersion;
            return String.valueOf(parent.getName()) + " (ID " + parent.getRequirementId().toString() + ")";
        }
        return "";
    }

    public List<RequirementVersionData> getChildren() {
        return this.childrenRequirements;
    }

    public List<RequirementVersionData> getAllChildren() {
        LinkedList<RequirementVersionData> allChildren = new LinkedList<RequirementVersionData>(this.childrenRequirements);
        for (RequirementVersionData child : this.childrenRequirements) {
            allChildren.addAll(child.getAllChildren());
        }
        return allChildren;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public Long getRequirementId() {
        return this.requirementId;
    }

    public void setRequirementId(Long requirementId) {
        this.requirementId = requirementId;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Integer getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getCriticality() {
        return this.criticality;
    }

    public void setCriticality(String criticality) {
        this.criticality = criticality;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCategory() {
        return this.category.toLowerCase();
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public List<ReqLinkData> getReqLinks() {
        return this.reqLinks;
    }

    public void setReqLinks(List<ReqLinkData> reqLinks) {
        this.reqLinks = reqLinks;
    }

    public boolean acceptsAsReqLink(ReqLinkData cufData) {
        return cufData.getReqVersionId().equals(this.versionId);
    }

    public List<AttachReq> getAttachReqs() {
        return this.attachReqs;
    }

    public void setAttachReqs(List<AttachReq> attachReqs) {
        this.attachReqs = attachReqs;
    }

    public String getCategoryType() {
        return this.categoryType;
    }

    public void setCategoryType(String categoryType) {
        this.categoryType = categoryType;
    }

    public int getNbAttachments() {
        return this.nbAttachments;
    }

    public void setNbAttachments(int nbAttachments) {
        this.nbAttachments = nbAttachments;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    public void setModifiedOn(Date modifuedOn) {
        this.modifiedOn = modifuedOn;
    }

    public Collection<TestCaseData> getBoundTestCases() {
        return this.boundTestCases;
    }

    public void setBoundTestCases(List<TestCaseData> boundTestCases) {
        this.boundTestCases = boundTestCases;
    }

    public List<CufPair> getCufPairs() {
        return this.cufPairs;
    }

    public void setCufs(List<CufData> cufs) {
        Iterator<CufData> it = cufs.iterator();
        while (it.hasNext()) {
            CufData next = it.next();
            CufPair pair = new CufPair();
            pair.setFirstCuf(next);
            if (it.hasNext()) {
                pair.setSecondCuf(it.next());
            }
            this.cufPairs.add(pair);
        }
    }

    public void setRtfCufs(List<CufData> cufs) {
        this.rtfCufs = cufs;
    }

    public List<CufData> getRtfCufs() {
        ArrayList<CufData> liste = new ArrayList<CufData>(this.rtfCufs);
        liste.addAll(this.getTagCufs());
        return liste;
    }

    public List<CufData> getNumCufs() {
        return this.numCufs;
    }

    public void setNumCufs(List<CufData> cufs) {
        this.numCufs = cufs;
    }

    public String getMilestoneLabels() {
        return this.milestoneLabels;
    }

    public void setMilestoneLabels(String milestoneLabels) {
        this.milestoneLabels = milestoneLabels;
    }

    public void addAllTestCases(Collection<TestCaseData> data) {
        this.boundTestCases.addAll(data);
    }

    public void addTestCase(TestCaseData data) {
        this.boundTestCases.add(data);
    }

    public int getTotalVersionNumber() {
        return this.totalVersionNumber;
    }

    public void setTotalVersionNumber(int totalVersionNumber) {
        this.totalVersionNumber = totalVersionNumber;
    }

    public boolean hasAttachments() {
        return this.nbAttachments > 0;
    }

    public boolean hasParentFolder() {
        return this.parentFolderId != null;
    }

    public boolean acceptsAsContent(TestCaseData testCase) {
        return testCase.getRequirementVersionId().equals(this.versionId);
    }

    public boolean acceptsAsCuf(CufData cufData) {
        return cufData.getReqVersionId().equals(this.versionId);
    }

    public void sortContent() {
        Collections.sort(this.boundTestCases, new TestCaseSorter());
    }

    private class TestCaseSorter
    implements Comparator<TestCaseData> {
        private TestCaseSorter() {
        }

        @Override
        public int compare(TestCaseData tc1, TestCaseData tc2) {
            String name1 = this.normalizeName(tc1);
            String name2 = this.normalizeName(tc2);
            return name1.compareTo(name2);
        }

        private String normalizeName(TestCaseData data) {
            if (StringUtils.isNotBlank((CharSequence)data.getReference())) {
                return String.valueOf(data.getReference()) + " - " + data.getName();
            }
            return data.getName();
        }
    }
}

