/*
 * Decompiled with CFR 0.152.
 */
package xsquash4gitlab.com.apollographql.apollo;

import xsquash4gitlab.com.apollographql.apollo.api.Operation;
import xsquash4gitlab.com.apollographql.apollo.api.Response;
import xsquash4gitlab.com.apollographql.apollo.cache.CacheHeaders;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloCanceledException;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloException;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloHttpException;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloNetworkException;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloParseException;
import xsquash4gitlab.com.apollographql.apollo.internal.util.Cancelable;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;
import xsquash4gitlab.org.jetbrains.annotations.Nullable;

public interface ApolloCall<T>
extends Cancelable {
    public void enqueue(@Nullable Callback<T> var1);

    @Deprecated
    @NotNull
    public ApolloCall<T> cacheHeaders(@NotNull CacheHeaders var1);

    @Deprecated
    @NotNull
    public ApolloCall<T> clone();

    @NotNull
    public Operation operation();

    @Override
    public void cancel();

    @NotNull
    public Builder<T> toBuilder();

    public static enum StatusEvent {
        SCHEDULED,
        FETCH_CACHE,
        FETCH_NETWORK,
        COMPLETED;

    }

    public static abstract class Callback<T> {
        public abstract void onResponse(@NotNull Response<T> var1);

        public abstract void onFailure(@NotNull ApolloException var1);

        public void onStatusEvent(@NotNull StatusEvent event) {
        }

        public void onHttpError(@NotNull ApolloHttpException e) {
            this.onFailure(e);
            xsquash4gitlab.okhttp3.Response response = e.rawResponse();
            if (response != null) {
                response.close();
            }
        }

        public void onNetworkError(@NotNull ApolloNetworkException e) {
            this.onFailure(e);
        }

        public void onParseError(@NotNull ApolloParseException e) {
            this.onFailure(e);
        }

        public void onCanceledError(@NotNull ApolloCanceledException e) {
            this.onFailure(e);
        }
    }

    public static interface Builder<T> {
        @NotNull
        public ApolloCall<T> build();

        @NotNull
        public Builder<T> cacheHeaders(@NotNull CacheHeaders var1);
    }
}

