/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.execplan;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.execplan.ExecplanGitLabIssue;

public class ExecplanIssuePartition {
    private Map<String, ExecplanGitLabIssue> features = new HashMap<String, ExecplanGitLabIssue>();
    private Map<String, ExecplanGitLabIssue> coveredFeatures = new HashMap<String, ExecplanGitLabIssue>();
    private Map<String, ExecplanGitLabIssue> bugfixes = new HashMap<String, ExecplanGitLabIssue>();
    private Map<String, ExecplanGitLabIssue> unrelated = new HashMap<String, ExecplanGitLabIssue>();

    public ExecplanGitLabIssue getFeature(String key) {
        return this.features.get(key);
    }

    public ExecplanGitLabIssue getCoveredFeature(String key) {
        return this.coveredFeatures.get(key);
    }

    public ExecplanGitLabIssue getBugfix(String key) {
        return this.bugfixes.get(key);
    }

    public ExecplanGitLabIssue getUnrelated(String key) {
        return this.unrelated.get(key);
    }

    public void addFeature(ExecplanGitLabIssue feature) {
        this.features.put(feature.getId(), feature);
    }

    public void addCoveredFeature(ExecplanGitLabIssue coveredFeature) {
        this.coveredFeatures.put(coveredFeature.getId(), coveredFeature);
    }

    public void addBugfix(ExecplanGitLabIssue bugfix) {
        this.bugfixes.put(bugfix.getId(), bugfix);
    }

    public void addUnrelated(ExecplanGitLabIssue feature) {
        this.unrelated.put(feature.getId(), feature);
    }

    public Set<ExecplanGitLabIssue> getFeatures() {
        return new HashSet<ExecplanGitLabIssue>(this.features.values());
    }

    public Set<ExecplanGitLabIssue> getCoveredFeatures() {
        return new HashSet<ExecplanGitLabIssue>(this.coveredFeatures.values());
    }

    public Set<ExecplanGitLabIssue> getBugfixes() {
        return new HashSet<ExecplanGitLabIssue>(this.bugfixes.values());
    }

    public Set<ExecplanGitLabIssue> getUnrelated() {
        return new HashSet<ExecplanGitLabIssue>(this.unrelated.values());
    }

    public Set<String> getFeatureKeys() {
        return this.features.keySet();
    }

    public Set<String> getBugFixKeys() {
        return this.bugfixes.keySet();
    }

    public Set<String> getCoveredFeatureKeys() {
        return this.coveredFeatures.keySet();
    }

    public Set<String> getUnrelatedKeys() {
        return this.unrelated.keySet();
    }

    public String log() {
        StringBuilder builder = new StringBuilder("Issue Partition : \n");
        builder.append("\tfeatures : " + this.getFeatureKeys() + "\n");
        builder.append("\tcovered features : " + this.getCoveredFeatures() + "\n");
        builder.append("\tbugfixes : " + this.getBugFixKeys() + "\n");
        builder.append("\tunrelated : " + this.getUnrelated() + "\n");
        return builder.toString();
    }
}

