/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.Session;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.FieldMapping;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.UserConfiguration;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.web.backend.helper.JsonHelper;

@Repository(value="squash.tm.plugin.xsquash4gitlab.dao")
public class PluginRequirementDao {
    private static final String FIND_REQ_BY_REMOTE_SYNC_AND_REMOTE_KEY = "select reqVersion from RequirementVersion reqVersion inner join reqVersion.requirement.syncExtender extender where extender.remoteSynchronisation.id = :remoteSyncId and extender.remoteReqId = :issueKey";
    private final DSLContext DSL;
    private final GenericProjectManagerService projectManager;
    @PersistenceContext
    EntityManager em;
    @Inject
    private ObjectMapper jsonifier;

    public PluginRequirementDao(DSLContext dsl, GenericProjectManagerService projectManager) {
        this.DSL = dsl;
        this.projectManager = projectManager;
    }

    public void resetLastSyncDate(RemoteSynchronisation remoteSynchronisation) {
        this.DSL.update((Table)Tables.REQUIREMENT_SYNC_EXTENDER).set((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_LAST_UPDATED, (Object)new Timestamp(new Date().getTime())).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisation.getId())).execute();
    }

    public List<String> findAllSynchronisedKeys(Long remoteSyncId) {
        return this.DSL.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSyncId)).orderBy((OrderField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).fetch((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, String.class);
    }

    public List<ParentSynchronisation> findParentSynchronisations(int remoteIssueId) {
        return this.DSL.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).join((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)String.valueOf(remoteIssueId))).and(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)"squash.tm.plugin.xsquash4gitlab")).and(Tables.REMOTE_SYNCHRONISATION.SYNC_ENABLE.eq((Object)true)).fetchInto(ParentSynchronisation.class);
    }

    public void storeConfigurationForProject(Long projectId, UserConfiguration userConfiguration) {
        HashMap<String, String> storageConf = new HashMap<String, String>(5);
        List<FieldMapping> fieldMappings = userConfiguration.getFieldMappings();
        String strMappings = JsonHelper.serialize(fieldMappings);
        storageConf.put("attributeMappings", strMappings);
        String valueMapping = userConfiguration.getYamlFieldValueMapping();
        storageConf.put("valuesMapping", valueMapping);
        storageConf.put("testReportingEnabled", Boolean.toString(userConfiguration.isTestReportingEnabled()));
        this.projectManager.setPluginConfiguration(projectId.longValue(), WorkspaceType.REQUIREMENT_WORKSPACE, "squash.tm.plugin.xsquash4gitlab", storageConf);
    }

    public List<Long> findActiveGitLabRemoteSyncIds() {
        return this.DSL.select((SelectField)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID).from((TableLike)Tables.REMOTE_SYNCHRONISATION).where(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)"squash.tm.plugin.xsquash4gitlab")).and(Tables.REMOTE_SYNCHRONISATION.SYNC_ENABLE.isTrue()).orderBy((OrderField)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.desc()).fetch((Field)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID, Long.class);
    }

    public Map<Long, RemoteSynchronisation> findRemoteSynchronisations(List<Long> ids) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Session session = (Session)this.em.unwrap(Session.class);){
            MultiIdentifierLoadAccess multiLoadAccess = session.byMultipleIds(RemoteSynchronisation.class);
            List syncs = multiLoadAccess.multiLoad(ids);
            return syncs.stream().collect(Collectors.toMap(RemoteSynchronisation::getId, Function.identity()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public RequirementVersion findReqVersionByRemoteSyncIdAndIssueKey(String issueKey, Long remoteSyncId) {
        this.em.flush();
        return this.em.createQuery(FIND_REQ_BY_REMOTE_SYNC_AND_REMOTE_KEY, RequirementVersion.class).setParameter("remoteSyncId", (Object)remoteSyncId).setParameter("issueKey", (Object)issueKey).getResultStream().findFirst().orElse(null);
    }

    public List<String> findSprintReqVersionRemoteKeysBySprintIds(List<Long> squashSprintIds) {
        return this.DSL.select((SelectField)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).from((TableLike)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.eq((Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_VERSION_ID)).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(squashSprintIds)).fetchInto(String.class);
    }

    public List<Long> findSprintReqVersionIdsBySprintIds(List<Long> squashSprintIds) {
        return this.DSL.select((SelectField)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID).from((TableLike)Tables.SPRINT_REQ_VERSION).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(squashSprintIds)).fetchInto(Long.class);
    }

    public static final class ParentSynchronisation {
        public final Long remoteSynchronisationId;
        public final String remoteReqPerimeterStatus;

        public ParentSynchronisation(Long remoteSynchronisationId, String remoteReqPerimeterStatus) {
            this.remoteSynchronisationId = remoteSynchronisationId;
            this.remoteReqPerimeterStatus = remoteReqPerimeterStatus;
        }
    }
}

