/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugTimer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugTimer.class);
    private static final boolean PRINT_ON_EACH_MARK = false;
    private static final String PREFIX = "DEBUG TIMER : ";
    private static final DebugTimer INSTANCE = new DebugTimer();
    private boolean enabled = false;
    private boolean started = false;
    private long startTime;
    private long previousTime;
    private final List<String> messages = new ArrayList<String>();
    private Function<String, Void> customLogFunction;

    public static void setEnabled(boolean enabled) {
        DebugTimer.INSTANCE.enabled = enabled;
    }

    public static void start() {
        if (!DebugTimer.INSTANCE.enabled) {
            return;
        }
        DebugTimer.INSTANCE.previousTime = DebugTimer.INSTANCE.startTime = System.currentTimeMillis();
        DebugTimer.INSTANCE.messages.clear();
        DebugTimer.INSTANCE.started = true;
        DebugTimer.doLog(String.format("%stimer restarted.%n", PREFIX));
    }

    public static void mark(String message) {
        if (!DebugTimer.INSTANCE.enabled) {
            return;
        }
        if (DebugTimer.checkIfStarted()) {
            long now = System.currentTimeMillis();
            String line = String.format("%sms (total: %sms) - %s", now - DebugTimer.INSTANCE.previousTime, now - DebugTimer.INSTANCE.startTime, message);
            DebugTimer.INSTANCE.messages.add(line);
            DebugTimer.INSTANCE.previousTime = now;
        }
    }

    public static void flush() {
        if (!DebugTimer.INSTANCE.enabled) {
            return;
        }
        if (DebugTimer.checkIfStarted()) {
            DebugTimer.doLog(String.format("%sFlushing messages collected so far :%n", PREFIX));
            for (String message : DebugTimer.INSTANCE.messages) {
                DebugTimer.doLog(message);
            }
        }
    }

    public static void setCustomLogger(Function<String, Void> customLogFunction) {
        DebugTimer.INSTANCE.customLogFunction = customLogFunction;
    }

    private static boolean checkIfStarted() {
        if (!DebugTimer.INSTANCE.started) {
            DebugTimer.doLog("Error : you have to start the timer once before collecting or flushing messages.");
            return false;
        }
        return true;
    }

    private static void doLog(String message) {
        if (DebugTimer.INSTANCE.customLogFunction != null) {
            DebugTimer.INSTANCE.customLogFunction.apply(message);
        } else {
            LOGGER.debug(message);
        }
    }
}

