/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.converter;

import java.util.Optional;
import org.springframework.lang.Nullable;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabNamedReferenceDto;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.ObjectPropertyExtractor;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.StringPropertyExtractor;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabNote;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.InvalidGitLabResponseException;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetGroupIdQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetProjectIdQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.IsEnterpriseEditionQuery;

public class GitLabConverters {
    public static Optional<String> extractProjectId(@Nullable GetProjectIdQuery.Data data) {
        return Optional.ofNullable(data).map(GetProjectIdQuery.Data::project).map(GetProjectIdQuery.Project::id);
    }

    public static Optional<String> extractGroupId(@Nullable GetGroupIdQuery.Data data) {
        return Optional.ofNullable(data).map(GetGroupIdQuery.Data::group).map(GetGroupIdQuery.Group::id);
    }

    public static InvalidGitLabResponseException exception(String message) {
        return new InvalidGitLabResponseException(message);
    }

    public static <T> GitLabNamedReferenceDto extractNamedReference(T entity, StringPropertyExtractor<T> idExtractor, StringPropertyExtractor<T> titleExtractor) {
        if (entity == null) {
            return null;
        }
        return new GitLabNamedReferenceDto(idExtractor.extract(entity), titleExtractor.extract(entity));
    }

    public static <T> GitLabNote extractGitLabNote(T entity, ObjectPropertyExtractor<T> idExtractor, StringPropertyExtractor<T> bodyExtractor) {
        if (entity == null) {
            return null;
        }
        return new GitLabNote(idExtractor.extract(entity).toString(), bodyExtractor.extract(entity));
    }

    private GitLabConverters() {
        throw new IllegalStateException("This class is not meant to be instantiated.");
    }

    public static Optional<Boolean> extractIsEnterpriseEdition(@Nullable IsEnterpriseEditionQuery.Data data) {
        return Optional.ofNullable(data).map(IsEnterpriseEditionQuery.Data::metadata).map(IsEnterpriseEditionQuery.Metadata::enterprise);
    }
}

