/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.controller.webhook;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GenericHttpErrorDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.webhook.model.IssueEventRequestBody;
import org.squashtest.tm.plugin.xsquash4gitlab.service.webhook.IssueWebhookService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.webhook.WebhookSecretTokenProvider;

@RestController(value="squash.tm.plugin.xsquash4gitlab.WebHookController")
@RequestMapping
public class WebHookController {
    public static final String MAPPING = "/plugin/xsquash4gitlab/webhook/issue";
    public static final String HEADER_GITLAB_EVENT = "X-Gitlab-Event";
    private static final String TEST_EVENT_TYPE = "Test Configuration Hook";
    public static final List<String> ACCEPTED_EVENT_TYPES = Arrays.asList("Issue Hook", "Confidential Issue Hook", "Test Configuration Hook");
    private static final String HEADER_GITLAB_TOKEN = "X-Gitlab-Token";
    private final IssueWebhookService issueWebhookService;
    private final WebhookSecretTokenProvider webhookSecretTokenProvider;

    @Autowired
    public WebHookController(IssueWebhookService issueWebhookService, WebhookSecretTokenProvider webhookSecretTokenProvider) {
        this.issueWebhookService = issueWebhookService;
        this.webhookSecretTokenProvider = webhookSecretTokenProvider;
    }

    @PostMapping(value={"/plugin/xsquash4gitlab/webhook/issue"})
    public ResponseEntity<GenericHttpErrorDto> handleIssueEvent(@RequestHeader(value="X-Gitlab-Event") String gitlabEvent, @RequestHeader(value="X-Gitlab-Token", required=false) String gitlabToken, @RequestParam(required=false) String token, @RequestBody IssueEventRequestBody requestBody) {
        String tokenToUse;
        if (!ACCEPTED_EVENT_TYPES.contains(gitlabEvent)) {
            return WebHookController.unhandledWebhookTypeResponse(gitlabEvent);
        }
        String string = tokenToUse = gitlabToken == null ? token : gitlabToken;
        if (!this.hasValidToken(tokenToUse)) {
            return GenericHttpErrorDto.buildErrorResponse(HttpStatus.UNAUTHORIZED, "The secret token does not match.");
        }
        if (!TEST_EVENT_TYPE.equals(gitlabEvent)) {
            this.issueWebhookService.appendToQueue(IssueEventRequestBody.toQueuedEvent(requestBody));
        }
        return ResponseEntity.ok(null);
    }

    private boolean hasValidToken(String candidateToken) {
        return !this.hasSecretTokenRegistered() || this.getSecretToken().equals(candidateToken);
    }

    private boolean hasSecretTokenRegistered() {
        return !StringUtils.isBlank((String)this.getSecretToken());
    }

    public String getSecretToken() {
        return this.webhookSecretTokenProvider.getSecretToken();
    }

    public static ResponseEntity<GenericHttpErrorDto> unhandledWebhookTypeResponse(String rejectedValue) {
        String joinedAcceptedTypes = ACCEPTED_EVENT_TYPES.stream().map(v -> String.format("'%s'", v)).collect(Collectors.joining(", "));
        String message = String.format("Invalid event type '%s'. The accepted values are %s.", rejectedValue, joinedAcceptedTypes);
        return GenericHttpErrorDto.buildErrorResponse(HttpStatus.BAD_REQUEST, message);
    }
}

