/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.AbstractJsonHttpMessageConverter;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.squashtest.tm.plugin.rest.core.configuration.RestApiProperties;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;

public class RestApiHandlerMapping
extends RequestMappingHandlerMapping {
    private static final MediaType EVERYTHING_JSON_MEDIA_TYPE = new MediaType("application", "*+json", AbstractJsonHttpMessageConverter.DEFAULT_CHARSET);
    private RestApiProperties properties;
    private List<Object> extraInterceptors = new ArrayList<Object>();
    private String basePath;

    public RestApiHandlerMapping(RestApiProperties properties) {
        this.properties = properties;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo info = super.getMappingForMethod(method, handlerType);
        if (info == null) {
            return null;
        }
        PatternsRequestCondition patternsCondition = this.customize(info.getPatternsCondition(), this.basePath);
        ProducesRequestCondition producesCondition = info.getProducesCondition();
        if (AnnotationUtils.findAnnotation(handlerType, UseDefaultRestApiConfiguration.class) != null) {
            producesCondition = this.customize(info.getProducesCondition());
        }
        return new RequestMappingInfo(patternsCondition, info.getMethodsCondition(), info.getParamsCondition(), info.getHeadersCondition(), info.getConsumesCondition(), producesCondition, info.getCustomCondition());
    }

    protected PatternsRequestCondition customize(PatternsRequestCondition condition, String prefix) {
        Set patterns = condition.getPatterns();
        String[] augmentedPatterns = new String[patterns.size()];
        int count = 0;
        for (String pattern : patterns) {
            augmentedPatterns[count++] = prefix.concat(pattern);
        }
        return new PatternsRequestCondition(augmentedPatterns, this.getUrlPathHelper(), this.getPathMatcher(), this.useSuffixPatternMatch(), this.useTrailingSlashMatch(), this.getFileExtensions());
    }

    protected ProducesRequestCondition customize(ProducesRequestCondition condition) {
        if (!condition.isEmpty()) {
            return condition;
        }
        LinkedHashSet<String> mediaTypes = new LinkedHashSet<String>();
        mediaTypes.add("application/json");
        mediaTypes.add(EVERYTHING_JSON_MEDIA_TYPE.toString());
        return new ProducesRequestCondition(mediaTypes.toArray(new String[mediaTypes.size()]));
    }

    public void addInterceptor(Object interceptor) {
        this.extraInterceptors.add(interceptor);
    }

    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, RestApiController.class) != null;
    }

    protected void extendInterceptors(List<Object> interceptors) {
        interceptors.addAll(this.extraInterceptors);
    }

    public void afterPropertiesSet() {
        this.basePath = this.properties.getNormalizedBasePath();
        super.afterPropertiesSet();
    }
}

