/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.util.StringUtils;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;
import org.squashtest.tm.plugin.rest.core.web.BasicResourceAssembler;
import org.squashtest.tm.plugin.rest.core.web.IRestController;

public abstract class BaseRestController
implements IRestController {
    @Inject
    protected BasePathAwareLinkBuildingService linkService;
    @Inject
    protected PagedResourcesAssembler pageAssembler;
    @Inject
    private BasicResourceAssembler resAssembler;

    protected <ENTITY extends Identified> LinkBuilder fromBasePath(WebMvcLinkBuilder builder) {
        return this.linkService.fromBasePath(builder);
    }

    protected <ENTITY extends Identified> Link createSelfLink(ENTITY entity) {
        return this.linkService.createSelfLink(entity);
    }

    protected <ENTITY extends Identified> Link createLinkTo(ENTITY entity) {
        return this.linkService.createLinkTo(entity);
    }

    protected <ENTITY extends Identified> Link createLinkTo(Class<ENTITY> clazz, Long id) {
        return this.linkService.createLinkTo(clazz, id);
    }

    protected <ENTITY extends Identified> Link createRelationTo(String relname) {
        return this.linkService.createRelationRelativeToCurrentUri(relname);
    }

    protected <ENTITY extends Identified> Link createRelationTo(ENTITY entity, String relname) {
        return this.linkService.createRelationTo(entity, relname);
    }

    protected <ENTITY extends Identified> EntityModel<ENTITY> toEntityModel(ENTITY object) {
        return this.resAssembler.toModel(object);
    }

    protected <T> PagedModel<EntityModel<T>> toPagedModel(Page<T> page) {
        return this.pageAssembler.toModel(page, (RepresentationModelAssembler)this.resAssembler);
    }

    protected <T> SingleRelPagedResources<EntityModel<T>> toPagedResourcesWithRel(Page<T> page, String rel) {
        PagedModel res = this.pageAssembler.toModel(page, (RepresentationModelAssembler)this.resAssembler);
        return new SingleRelPagedResources<EntityModel<T>>(res, rel);
    }

    protected List<String> getFields(String fields) {
        if (!StringUtils.hasLength((String)fields)) {
            return Collections.emptyList();
        }
        return List.of(fields.split(","));
    }
}

