/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.openid.connect.controller;

import java.util.Objects;
import javax.servlet.http.HttpSession;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class SquashOidcFailureController {
    public static final String AUTH_FAILURE_URL = "/auth/oidc/authentication-failure";
    public static final String AUTH_FAILURE_TEMPLATE_URL = "oidc/authentication-failure.html";

    @GetMapping(value={"/auth/oidc/authentication-failure"})
    public String showAuthenticationFailurePage(HttpSession session, Model model) {
        Exception ex = this.extractException(session);
        AutopsyReport report = null;
        if (session != null) {
            report = this.autopsy(ex);
        }
        model.addAttribute("report", (Object)report);
        return AUTH_FAILURE_TEMPLATE_URL;
    }

    private Exception extractException(HttpSession session) {
        return session != null ? (Exception)session.getAttribute("SPRING_SECURITY_LAST_EXCEPTION") : null;
    }

    private AutopsyReport autopsy(Exception ex) {
        int maxDepth = 6;
        int count = 0;
        Throwable cause = ex;
        while (count++ < maxDepth && cause.getCause() != null) {
            cause = cause.getCause();
        }
        AutopsyReport report = count >= maxDepth ? new AutopsyReport(FailureReason.UNKNOWN, cause, false) : (this.unauthorizedUser(cause) ? new AutopsyReport(FailureReason.UNAUTHORIZED_USER, cause, true) : (this.invalidIdpConfiguration(cause) ? new AutopsyReport(FailureReason.IDP_CONFIGURATION, cause, true) : new AutopsyReport(FailureReason.UNKNOWN, cause, true)));
        return report;
    }

    private boolean invalidIdpConfiguration(Throwable cause) {
        return OAuth2AuthenticationException.class.isAssignableFrom(cause.getClass());
    }

    private boolean unauthorizedUser(Throwable cause) {
        return AccessDeniedException.class.isAssignableFrom(cause.getClass());
    }

    protected static final class AutopsyReport {
        private final boolean completed;
        private final FailureReason reason;
        private final Throwable cause;

        AutopsyReport(FailureReason reason, Throwable cause, boolean completed) {
            this.completed = completed;
            this.reason = reason;
            this.cause = cause;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public FailureReason getReason() {
            return this.reason;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutopsyReport that = (AutopsyReport)o;
            return this.completed == that.completed && this.reason == that.reason && Objects.equals(this.cause, that.cause);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.completed, this.reason, this.cause});
        }
    }

    private static enum FailureReason {
        IDP_CONFIGURATION,
        UNAUTHORIZED_USER,
        UNKNOWN;

    }
}

