/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.trust.httpclient;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.x509.BasicPKIXValidationInformation;
import org.opensaml.xml.security.x509.BasicX509CredentialNameEvaluator;
import org.opensaml.xml.security.x509.CertPathPKIXValidationOptions;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.PKIXX509CredentialTrustEngine;
import org.opensaml.xml.security.x509.StaticPKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sqsaml.org.apache.commons.httpclient.params.HttpConnectionParams;
import sqsaml.org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import sqsaml.org.springframework.security.saml.key.KeyManager;
import sqsaml.org.springframework.security.saml.trust.CertPathPKIXTrustEvaluator;
import sqsaml.org.springframework.security.saml.trust.X509KeyManager;
import sqsaml.org.springframework.security.saml.trust.X509TrustManager;
import sqsaml.org.springframework.security.saml.util.SAMLUtil;

public class TLSProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Logger log = LoggerFactory.getLogger(TLSProtocolSocketFactory.class);
    private KeyManager keyManager;
    private String sslHostnameVerification = "default";
    private Set<String> trustedKeys;
    private SecureProtocolSocketFactory socketFactory;

    public TLSProtocolSocketFactory(KeyManager keyManager, Set<String> trustedKeys, String sslHostnameVerification) {
        this.keyManager = keyManager;
        this.sslHostnameVerification = sslHostnameVerification;
        this.trustedKeys = trustedKeys;
        this.socketFactory = this.initializeDelegate();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.socketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int clientPort) throws IOException {
        return this.socketFactory.createSocket(host, port, localHost, clientPort);
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.socketFactory.createSocket(socket, host, port, autoClose);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort, HttpConnectionParams connParams) throws IOException {
        return this.socketFactory.createSocket(host, port, localHost, localPort, connParams);
    }

    protected SecureProtocolSocketFactory initializeDelegate() {
        CertPathPKIXValidationOptions pkixOptions = new CertPathPKIXValidationOptions();
        PKIXValidationInformationResolver pkixResolver = this.getPKIXResolver();
        CertPathPKIXTrustEvaluator pkixTrustEvaluator = new CertPathPKIXTrustEvaluator(pkixOptions);
        PKIXX509CredentialTrustEngine trustEngine = new PKIXX509CredentialTrustEngine(pkixResolver, pkixTrustEvaluator, new BasicX509CredentialNameEvaluator());
        X509KeyManager keyManager = new X509KeyManager((X509Credential)this.keyManager.getDefaultCredential());
        X509TrustManager trustManager = new X509TrustManager(new CriteriaSet(), trustEngine);
        HostnameVerifier hostnameVerifier = SAMLUtil.getHostnameVerifier(this.sslHostnameVerification);
        if (this.isHostnameVerificationSupported()) {
            return new org.opensaml.ws.soap.client.http.TLSProtocolSocketFactory(keyManager, trustManager, hostnameVerifier);
        }
        return new org.opensaml.ws.soap.client.http.TLSProtocolSocketFactory(keyManager, trustManager);
    }

    protected PKIXValidationInformationResolver getPKIXResolver() {
        if (this.trustedKeys == null) {
            this.trustedKeys = this.keyManager.getAvailableCredentials();
        }
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(this.trustedKeys.size());
        for (String key : this.trustedKeys) {
            log.debug("Adding PKIX trust anchor {} for SSL/TLS verification {}", (Object)key);
            certificates.add(this.keyManager.getCertificate(key));
        }
        LinkedList<PKIXValidationInformation> info = new LinkedList<PKIXValidationInformation>();
        info.add(new BasicPKIXValidationInformation(certificates, null, 4));
        return new StaticPKIXValidationInformationResolver(info, null);
    }

    protected boolean isHostnameVerificationSupported() {
        try {
            org.opensaml.ws.soap.client.http.TLSProtocolSocketFactory.class.getConstructor(javax.net.ssl.X509KeyManager.class, javax.net.ssl.X509TrustManager.class, HostnameVerifier.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            log.warn("HostnameVerification is not supported, update your OpenSAML libraries");
            return false;
        }
    }
}

