/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.trust;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sqsaml.org.springframework.security.saml.key.KeyManager;
import sqsaml.org.springframework.security.saml.metadata.ExtendedMetadata;
import sqsaml.org.springframework.security.saml.metadata.MetadataManager;

public class MetadataCredentialResolver
extends org.opensaml.security.MetadataCredentialResolver {
    private final Logger log = LoggerFactory.getLogger(MetadataCredentialResolver.class);
    protected MetadataManager manager;
    protected KeyManager keyManager;
    private boolean useXmlMetadata = true;
    private boolean useExtendedMetadata = true;

    public MetadataCredentialResolver(MetadataManager metadataProvider, KeyManager keyManager) {
        super(metadataProvider);
        this.manager = metadataProvider;
        this.keyManager = keyManager;
    }

    @Override
    protected Collection<Credential> retrieveFromMetadata(String entityID, QName role, String protocol, UsageType usage) throws SecurityException {
        try {
            ArrayList<Credential> credentials = new ArrayList<Credential>();
            if (this.useExtendedMetadata) {
                ExtendedMetadata extendedMetadata = this.manager.getExtendedMetadata(entityID);
                if (usage.equals((Object)UsageType.UNSPECIFIED)) {
                    if (extendedMetadata.getSigningKey() != null) {
                        this.log.debug("Using customized signing key {} from extended metadata for entityID {}", (Object)extendedMetadata.getSigningKey(), (Object)entityID);
                        credentials.add(this.keyManager.getCredential(extendedMetadata.getSigningKey()));
                    }
                    if (extendedMetadata.getEncryptionKey() != null) {
                        this.log.debug("Using customized encryption key {} from extended metadata for entityID {}", (Object)extendedMetadata.getEncryptionKey(), (Object)entityID);
                        credentials.add(this.keyManager.getCredential(extendedMetadata.getEncryptionKey()));
                    }
                    if (extendedMetadata.getTlsKey() != null) {
                        this.log.debug("Using customized TLS key {} from extended metadata for entityID {}", (Object)extendedMetadata.getEncryptionKey(), (Object)entityID);
                        credentials.add(this.keyManager.getCredential(extendedMetadata.getTlsKey()));
                    }
                } else if (usage.equals((Object)UsageType.SIGNING)) {
                    if (extendedMetadata.getSigningKey() != null) {
                        this.log.debug("Using customized signing key {} from extended metadata for entityID {}", (Object)extendedMetadata.getSigningKey(), (Object)entityID);
                        credentials.add(this.keyManager.getCredential(extendedMetadata.getSigningKey()));
                    }
                } else if (usage.equals((Object)UsageType.ENCRYPTION) && extendedMetadata.getEncryptionKey() != null) {
                    this.log.debug("Using customized encryption key {} from extended metadata for entityID {}", (Object)extendedMetadata.getEncryptionKey(), (Object)entityID);
                    credentials.add(this.keyManager.getCredential(extendedMetadata.getEncryptionKey()));
                }
            }
            if (this.useXmlMetadata) {
                Collection<Credential> metadataCredentials = super.retrieveFromMetadata(entityID, role, protocol, usage);
                credentials.addAll(metadataCredentials);
                this.log.debug("Added {} credentials resolved from metadata of entity {}", (Object)metadataCredentials.size(), (Object)entityID);
            }
            return credentials;
        }
        catch (MetadataProviderException e) {
            throw new SecurityException("Error loading metadata information", e);
        }
    }

    public void setUseXmlMetadata(boolean useXmlMetadata) {
        this.useXmlMetadata = useXmlMetadata;
    }

    public void setUseExtendedMetadata(boolean useExtendedMetadata) {
        this.useExtendedMetadata = useExtendedMetadata;
    }
}

