/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.waf.rules;

import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sqsaml.org.owasp.esapi.waf.actions.Action;
import sqsaml.org.owasp.esapi.waf.actions.DefaultAction;
import sqsaml.org.owasp.esapi.waf.actions.DoNothingAction;
import sqsaml.org.owasp.esapi.waf.internal.InterceptingHTTPServletRequest;
import sqsaml.org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import sqsaml.org.owasp.esapi.waf.rules.Rule;

public class GeneralAttackSignatureRule
extends Rule {
    private Pattern signature;

    public GeneralAttackSignatureRule(String id, Pattern signature) {
        this.signature = signature;
        this.setId(id);
    }

    @Override
    public Action check(HttpServletRequest req, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        InterceptingHTTPServletRequest request = (InterceptingHTTPServletRequest)req;
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String param = (String)e.nextElement();
            if (!this.signature.matcher(request.getDictionaryParameter(param)).matches()) continue;
            this.log((HttpServletRequest)request, "General attack signature detected in parameter '" + param + "' value '" + request.getDictionaryParameter(param) + "'");
            return new DefaultAction();
        }
        return new DoNothingAction();
    }
}

