/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.waf.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import sqsaml.org.owasp.esapi.waf.internal.InterceptingPrintWriter;
import sqsaml.org.owasp.esapi.waf.internal.InterceptingServletOutputStream;
import sqsaml.org.owasp.esapi.waf.rules.AddHTTPOnlyFlagRule;
import sqsaml.org.owasp.esapi.waf.rules.AddSecureFlagRule;
import sqsaml.org.owasp.esapi.waf.rules.Rule;

public class InterceptingHTTPServletResponse
extends HttpServletResponseWrapper {
    private InterceptingPrintWriter ipw;
    private InterceptingServletOutputStream isos;
    private String contentType;
    private List<AddSecureFlagRule> addSecureFlagRules = null;
    private List<AddHTTPOnlyFlagRule> addHTTPOnlyFlagRules = null;
    private boolean alreadyCalledWriter = false;
    private boolean alreadyCalledOutputStream = false;

    public InterceptingHTTPServletResponse(HttpServletResponse response, boolean buffering, List<Rule> cookieRules) throws IOException {
        super(response);
        this.contentType = response.getContentType();
        this.isos = new InterceptingServletOutputStream(response.getOutputStream(), buffering);
        this.ipw = new InterceptingPrintWriter(new PrintWriter((OutputStream)((Object)this.isos)));
        this.addSecureFlagRules = new ArrayList<AddSecureFlagRule>();
        this.addHTTPOnlyFlagRules = new ArrayList<AddHTTPOnlyFlagRule>();
        for (int i = 0; i < cookieRules.size(); ++i) {
            Rule r = cookieRules.get(i);
            if (r instanceof AddSecureFlagRule) {
                this.addSecureFlagRules.add((AddSecureFlagRule)r);
                continue;
            }
            if (!(r instanceof AddHTTPOnlyFlagRule)) continue;
            this.addHTTPOnlyFlagRules.add((AddHTTPOnlyFlagRule)r);
        }
    }

    public boolean isUsingWriter() {
        return this.alreadyCalledWriter;
    }

    public InterceptingServletOutputStream getInterceptingServletOutputStream() {
        return this.isos;
    }

    public ServletOutputStream getOutputStream() throws IllegalStateException, IOException {
        if (this.alreadyCalledWriter) {
            throw new IllegalStateException();
        }
        this.alreadyCalledOutputStream = true;
        return this.isos;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.alreadyCalledOutputStream) {
            throw new IllegalStateException();
        }
        this.alreadyCalledWriter = true;
        return this.ipw;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String s) {
        this.contentType = s;
    }

    public void flush() {
        this.ipw.flush();
    }

    public void commit() throws IOException {
        if (this.alreadyCalledWriter) {
            this.ipw.flush();
        }
        this.isos.commit();
    }

    public void addCookie(Cookie cookie) {
        this.addCookie(cookie, cookie.getMaxAge() <= 0);
    }

    public void addCookie(Cookie cookie, boolean isSession) {
        int i;
        boolean addSecureFlag = cookie.getSecure();
        boolean addHTTPOnlyFlag = false;
        if (!cookie.getSecure() && this.addSecureFlagRules != null) {
            for (i = 0; i < this.addSecureFlagRules.size(); ++i) {
                AddSecureFlagRule asfr = this.addSecureFlagRules.get(i);
                if (!asfr.doesCookieMatch(cookie.getName())) continue;
                addSecureFlag = true;
            }
        }
        if (this.addHTTPOnlyFlagRules != null) {
            for (i = 0; i < this.addHTTPOnlyFlagRules.size(); ++i) {
                AddHTTPOnlyFlagRule ashr = this.addHTTPOnlyFlagRules.get(i);
                if (!ashr.doesCookieMatch(cookie.getName())) continue;
                addHTTPOnlyFlag = true;
            }
        }
        String cookieValue = this.createCookieHeader(cookie.getName(), cookie.getValue(), cookie.getMaxAge(), cookie.getDomain(), cookie.getPath(), addSecureFlag, addHTTPOnlyFlag, isSession);
        this.addHeader("Set-Cookie", cookieValue);
    }

    private String createCookieHeader(String name, String value, int maxAge, String domain, String path, boolean secure, boolean httpOnly, boolean isTemporary) {
        String header = name + "=" + value;
        if (!isTemporary) {
            header = header + "; Max-Age=" + maxAge;
        }
        if (domain != null) {
            header = header + "; Domain=" + domain;
        }
        if (path != null) {
            header = header + "; Path=" + path;
        }
        if (secure) {
            header = header + "; Secure";
        }
        if (httpOnly) {
            header = header + "; HttpOnly";
        }
        return header;
    }
}

