/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import sqsaml.org.owasp.esapi.errors.ConfigurationException;

public class ObjFactory {
    private static final int CACHE_INITIAL_CAPACITY = 32;
    private static final float CACHE_LOAD_FACTOR = 0.75f;
    private static final ConcurrentHashMap<String, Class<?>> CLASSES_CACHE = new ConcurrentHashMap(32, 0.75f);
    private static final ConcurrentHashMap<String, MethodWrappedInfo> METHODS_CACHE = new ConcurrentHashMap(32, 0.75f);
    private static boolean cacheEnabled = true;

    public static <T> T make(String className, String typeName) throws ConfigurationException {
        Object obj = null;
        String errMsg = null;
        try {
            if (null == className || "".equals(className)) {
                throw new IllegalArgumentException("Classname cannot be null or empty.");
            }
            if (null == typeName || "".equals(typeName)) {
                typeName = "[unknown?]";
            }
            Class<?> theClass = ObjFactory.loadClassByStringName(className);
            try {
                Method singleton = ObjFactory.findSingletonCreateMethod(className, theClass);
                obj = singleton.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                obj = theClass.newInstance();
            }
            catch (SecurityException e) {
                throw new ConfigurationException("The SecurityManager has restricted the object factory from getting a reference to the singleton implementation of the class [" + className + "]", e);
            }
            return (T)obj;
        }
        catch (IllegalArgumentException ex) {
            errMsg = ex.toString() + " " + typeName + " type name cannot be null or empty.";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (ClassNotFoundException ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") must be in class path.";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (InstantiationException ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") must be concrete.";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (IllegalAccessException ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") must have a public, no-arg constructor.";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (ClassCastException ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") must be a subtype of T in ObjFactory<T>";
            throw new ConfigurationException(errMsg, ex);
        }
        catch (Exception ex) {
            errMsg = ex.toString() + " " + typeName + " class (" + className + ") CTOR threw exception.";
            throw new ConfigurationException(errMsg, ex);
        }
    }

    public static void setCache(boolean enable) {
        cacheEnabled = enable;
    }

    private static Class<?> loadClassByStringName(String className) throws ClassNotFoundException {
        Class<?> clazz;
        if (cacheEnabled && CLASSES_CACHE.containsKey(className)) {
            clazz = CLASSES_CACHE.get(className);
        } else {
            clazz = Class.forName(className);
            if (cacheEnabled) {
                CLASSES_CACHE.putIfAbsent(className, clazz);
            }
        }
        return clazz;
    }

    private static Method findSingletonCreateMethod(String className, Class<?> theClass) throws NoSuchMethodException {
        MethodWrappedInfo singleton = ObjFactory.loadMethodByStringName(className, theClass);
        if (!singleton.isStaticMethod()) {
            throw singleton.getNonStaticEx();
        }
        return singleton.getMethod();
    }

    private static MethodWrappedInfo loadMethodByStringName(String className, Class<?> theClass) throws NoSuchMethodException {
        MethodWrappedInfo methodInfo;
        String methodName = className + "getInstance";
        if (cacheEnabled && METHODS_CACHE.containsKey(methodName)) {
            methodInfo = METHODS_CACHE.get(methodName);
        } else {
            Method method = theClass.getMethod("getInstance", new Class[0]);
            boolean staticMethod = Modifier.isStatic(method.getModifiers());
            ConfigurationException nonStaticEx = staticMethod ? null : new ConfigurationException("Class [" + className + "] contains a non-static getInstance method.");
            methodInfo = new MethodWrappedInfo(method, staticMethod, nonStaticEx);
            if (cacheEnabled) {
                METHODS_CACHE.putIfAbsent(methodName, methodInfo);
            }
        }
        return methodInfo;
    }

    private ObjFactory() {
    }

    private static class MethodWrappedInfo {
        private Method method;
        private boolean staticMethod;
        private ConfigurationException nonStaticEx;

        MethodWrappedInfo(Method method, boolean staticMethod, ConfigurationException nonStaticEx) {
            this.method = method;
            this.staticMethod = staticMethod;
            this.nonStaticEx = nonStaticEx;
        }

        Method getMethod() {
            return this.method;
        }

        boolean isStaticMethod() {
            return this.staticMethod;
        }

        ConfigurationException getNonStaticEx() {
            return this.nonStaticEx;
        }
    }
}

