/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.reference.accesscontrol.policyloader;

import sqsaml.org.apache.commons.configuration.XMLConfiguration;
import sqsaml.org.owasp.esapi.ESAPI;
import sqsaml.org.owasp.esapi.Logger;
import sqsaml.org.owasp.esapi.reference.accesscontrol.DynaBeanACRParameter;
import sqsaml.org.owasp.esapi.reference.accesscontrol.policyloader.ACRParameterLoader;
import sqsaml.org.owasp.esapi.reference.accesscontrol.policyloader.ACRParameterLoaderHelper;

public final class DynaBeanACRParameterLoader
implements ACRParameterLoader<DynaBeanACRParameter> {
    Logger logger = ESAPI.getLogger(this.getClass());

    @Override
    public DynaBeanACRParameter getParameters(XMLConfiguration config, int currentRule) throws Exception {
        DynaBeanACRParameter policyParameter = new DynaBeanACRParameter();
        int numberOfParameters = config.getList("AccessControlRules.AccessControlRule(" + currentRule + ").Parameters.Parameter[@name]").size();
        for (int currentParameter = 0; currentParameter < numberOfParameters; ++currentParameter) {
            String parameterName = config.getString("AccessControlRules.AccessControlRule(" + currentRule + ").Parameters.Parameter(" + currentParameter + ")[@name]");
            String parameterType = config.getString("AccessControlRules.AccessControlRule(" + currentRule + ").Parameters.Parameter(" + currentParameter + ")[@type]");
            Object parameterValue = ACRParameterLoaderHelper.getParameterValue(config, currentRule, currentParameter, parameterType);
            policyParameter.set(parameterName, parameterValue);
        }
        policyParameter.lock();
        this.logger.info(Logger.SECURITY_SUCCESS, "Loaded " + numberOfParameters + " parameters: " + policyParameter.toString());
        return policyParameter;
    }
}

