/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import sqsaml.org.owasp.esapi.ESAPI;
import sqsaml.org.owasp.esapi.configuration.AbstractPrioritizedPropertyLoader;
import sqsaml.org.owasp.esapi.errors.ConfigurationException;

public class StandardEsapiPropertyLoader
extends AbstractPrioritizedPropertyLoader {
    public StandardEsapiPropertyLoader(String filename, int priority) throws IOException {
        super(filename, priority);
    }

    @Override
    public int getIntProp(String propertyName) throws ConfigurationException {
        String property = this.properties.getProperty(propertyName);
        if (property == null) {
            throw new ConfigurationException("Property : " + propertyName + "not found in configuration");
        }
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Incorrect type of : " + propertyName + ". Value " + property + "cannot be converted to integer", e);
        }
    }

    @Override
    public byte[] getByteArrayProp(String propertyName) throws ConfigurationException {
        String property = this.properties.getProperty(propertyName);
        if (property == null) {
            throw new ConfigurationException("Property : " + propertyName + "not found in default configuration");
        }
        try {
            return ESAPI.encoder().decodeFromBase64(property);
        }
        catch (IOException e) {
            throw new ConfigurationException("Incorrect type of : " + propertyName + ". Value " + property + "cannot be converted to byte array", e);
        }
    }

    @Override
    public Boolean getBooleanProp(String propertyName) throws ConfigurationException {
        String property = this.properties.getProperty(propertyName);
        if (property == null) {
            throw new ConfigurationException("Property : " + propertyName + "not found in default configuration");
        }
        if (property.equalsIgnoreCase("true") || property.equalsIgnoreCase("yes")) {
            return true;
        }
        if (property.equalsIgnoreCase("false") || property.equalsIgnoreCase("no")) {
            return false;
        }
        throw new ConfigurationException("Incorrect type of : " + propertyName + ". Value " + property + "cannot be converted to boolean");
    }

    @Override
    public String getStringProp(String propertyName) throws ConfigurationException {
        String property = this.properties.getProperty(propertyName);
        if (property == null) {
            throw new ConfigurationException("Property : " + propertyName + "not found in default configuration");
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadPropertiesFromFile(File file) {
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            this.properties.load(input);
        }
        catch (IOException ex) {
            this.logSpecial("Loading " + file.getName() + " via file I/O failed.", ex);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    this.logSpecial("Could not close stream");
                }
            }
        }
    }
}

