/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.codecs.ref;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EncodingPatternPreservation {
    private static final String REPLACEMENT_MARKER = EncodingPatternPreservation.class.getSimpleName();
    private final Pattern noEncodeContent;
    private String replacementMarker = REPLACEMENT_MARKER;
    private final List<String> replacedContentList = new ArrayList<String>();

    public EncodingPatternPreservation(Pattern pattern) {
        this.noEncodeContent = pattern;
    }

    public String captureAndReplaceMatches(String input) {
        if (!this.replacedContentList.isEmpty()) {
            String message = "Previously captured state is still present in instance. Call PatternContentPreservation.reset() to clear out preserved state and to reuse the reference.";
            throw new IllegalStateException(message);
        }
        String inputCpy = input;
        Matcher matcher = this.noEncodeContent.matcher(input);
        while (matcher.find()) {
            String replaceContent = matcher.group(0);
            if (replaceContent == null) continue;
            this.replacedContentList.add(replaceContent);
            inputCpy = inputCpy.replaceFirst(this.noEncodeContent.pattern(), this.replacementMarker);
        }
        return inputCpy;
    }

    public String restoreOriginalContent(String input) {
        String result = input;
        while (this.replacedContentList.size() > 0) {
            String origValue = this.replacedContentList.remove(0);
            result = result.replaceFirst(this.replacementMarker, origValue);
        }
        return result;
    }

    public void setReplacementMarker(String marker) {
        if (!this.replacedContentList.isEmpty()) {
            String message = "Previously captured state is still present in instance. Call PatternContentPreservation.reset() to clear out preserved state and to alter the marker.";
            throw new IllegalStateException(message);
        }
        this.replacementMarker = marker;
    }

    public void reset() {
        this.replacedContentList.clear();
    }
}

