/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.cms.jcajce;

import java.security.PrivateKey;
import java.security.Provider;
import javax.crypto.SecretKey;
import sqsaml.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import sqsaml.org.bouncycastle.cms.jcajce.CMSUtils;
import sqsaml.org.bouncycastle.cms.jcajce.JcaJceExtHelper;
import sqsaml.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import sqsaml.org.bouncycastle.operator.SymmetricKeyUnwrapper;
import sqsaml.org.bouncycastle.operator.jcajce.JceAsymmetricKeyUnwrapper;
import sqsaml.org.bouncycastle.operator.jcajce.JceKTSKeyUnwrapper;
import sqsaml.org.bouncycastle.operator.jcajce.JceSymmetricKeyUnwrapper;

class ProviderJcaJceExtHelper
extends ProviderJcaJceHelper
implements JcaJceExtHelper {
    public ProviderJcaJceExtHelper(Provider provider) {
        super(provider);
    }

    public JceAsymmetricKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privateKey) {
        privateKey = CMSUtils.cleanPrivateKey(privateKey);
        return new JceAsymmetricKeyUnwrapper(algorithmIdentifier, privateKey).setProvider(this.provider);
    }

    public JceKTSKeyUnwrapper createAsymmetricUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privateKey, byte[] byArray, byte[] byArray2) {
        privateKey = CMSUtils.cleanPrivateKey(privateKey);
        return new JceKTSKeyUnwrapper(algorithmIdentifier, privateKey, byArray, byArray2).setProvider(this.provider);
    }

    public SymmetricKeyUnwrapper createSymmetricUnwrapper(AlgorithmIdentifier algorithmIdentifier, SecretKey secretKey) {
        return new JceSymmetricKeyUnwrapper(algorithmIdentifier, secretKey).setProvider(this.provider);
    }
}

